<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Booking;
use App\Models\Newsletter;
use App\Models\TourPackage;
use App\Models\User;
use App\Models\Destination;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class AdminDashboardController extends Controller
{
    public function index()
    {
        if (Auth::check() && Auth::user()->role !== 'admin') {
            abort(403, 'Unauthorized');
        }
        // Get total bookings (New Orders)
        $totalBookings = Booking::count();

        // Get total packages (replacing Booking Success Rate)
        $totalPackages = TourPackage::count();

        // Get total registered users
        $totalUsers = User::count();

        // Get total newsletter subscribers
        $totalSubscribers = Newsletter::count();

        // Data for charts
        // Bookings per month for the current year
        $bookingsPerMonth = Booking::select(
            DB::raw('MONTH(created_at) as month'),
            DB::raw('COUNT(*) as count')
        )
            ->whereYear('created_at', now()->year)
            ->groupBy('month')
            ->orderBy('month')
            ->get()
            ->pluck('count', 'month')
            ->toArray();

        // Fill missing months with 0
        $bookingsChartData = array_fill(1, 12, 0);
        foreach ($bookingsPerMonth as $month => $count) {
            $bookingsChartData[$month] = $count;
        }

        // Popular destinations (top 5 by bookings)
        $popularDestinations = Booking::select(
            'destinations.name',
            DB::raw('COUNT(bookings.id) as booking_count')
        )
            ->join('tour_packages', 'bookings.package_id', '=', 'tour_packages.id')
            ->join('destinations', 'tour_packages.category_id', '=', 'destinations.id')
            ->groupby('destinations.name')
            ->orderByDesc('booking_count')
            ->take(5)
            ->get()
            ->pluck('booking_count', 'name')
            ->toArray();

        return view('admin.dashboard', compact(
            'totalBookings',
            'totalPackages',
            'totalUsers',
            'totalSubscribers',
            'bookingsChartData',
            'popularDestinations'
        ));
    }
}
