<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Activity extends Model
{
    use HasFactory;

    protected $fillable = [
        'itinerary_id',
        'image_path',
        'name',
        'description',
    ];

    /**
     * Each activity belongs to an itinerary.
     */
    public function itinerary()
    {
        return $this->belongsTo(Itinerary::class);
    }
}
