<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_name',
        'package_id',
        'num_people',
        'expected_date',
        'country',
        'mobile',
        'email',
        'special_req',
    ];

    /**
     * A booking belongs to a tour package.
     */
    public function package()
    {
        return $this->belongsTo(TourPackage::class);
    }
}
