<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Destination extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * (optional, Laravel will auto-detect "destinations")
     */
    protected $table = 'destinations';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'address',
        'map_url',
        'description',
        'key_points',
        'image_path',
    ];

    /**
     * Cast attributes.
     */
    protected $casts = [
        'key_points' => 'array', // store JSON array if needed
    ];

    /**
     * A destination can have many events.
     */
    public function events()
    {
        return $this->hasMany(Event::class);
    }
}
