<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Event extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'destination_id',
    ];

    /**
     * Each event belongs to a destination.
     */
    public function destination()
    {
        return $this->belongsTo(Destination::class);
    }
}
