<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GalleryCategory extends Model
{
    use HasFactory;

    protected $table = 'gallery_categories';

    protected $fillable = [
        'name',
    ];

    // Relationship: A category has many images
    public function images()
    {
        return $this->hasMany(ImageGallery::class, 'category_id');
    }

    // Relationship: A category has many videos
    public function videos()
    {
        return $this->hasMany(VideoGallery::class, 'category_id');
    }
}
