<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ImageGallery extends Model
{
    use HasFactory;

    protected $table = 'image_galleries';

    protected $fillable = [
        'title',
        'image_path',
        'category_id',
    ];

    // Relationship: An image belongs to a category
    public function category()
    {
        return $this->belongsTo(GalleryCategory::class, 'category_id');
    }
}
