<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Itinerary extends Model
{
    use HasFactory;

    protected $fillable = [
        'detail',
        'order',
        'package_itinerary_id',
    ];

    protected $casts = [
        'order' => 'integer',
    ];

    /**
     * Each itinerary belongs to a package itinerary.
     */
    public function packageItinerary()
    {
        return $this->belongsTo(PackageItinerary::class);
    }

    /**
     * An itinerary can have many images.
     */
    public function images()
    {
        return $this->hasMany(ItineraryImage::class);
    }

    /**
     * Scope to order itineraries by order column
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order');
    }
}
