<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ItineraryImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_itinerary_id',
        'image_path',
        'caption',
        'day_number',
    ];

    /**
     * Each image belongs to a package itinerary.
     */
    public function itinerary()
    {
        return $this->belongsTo(PackageItinerary::class, 'package_itinerary_id');
    }
}
