<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PackageItinerary extends Model
{
    protected $table = 'package_itineraries';

    protected $fillable = [
        'package_id',
        'day_number',
        'title',
        'map_url',
        'description',
    ];

    /**
     * Friendly day accessor used in front-end templates
     */
    public function getDayAttribute()
    {
        return $this->day_number;
    }

    public function package()
    {
        return $this->belongsTo(TourPackage::class, 'package_id');
    }

    /**
     * A package itinerary can have many images (ItineraryImage records).
     */
    public function images()
    {
        return $this->hasMany(ItineraryImage::class, 'package_itinerary_id');
    }

    /**
     * A package itinerary can have many activities.
     */
    public function activities()
    {
        return $this->hasMany(\App\Models\Activity::class, 'itinerary_id');
    }
}
