<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Review extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_name',
        'ratings',
        'comments',
        'status',
        'package_id',
    ];

    /**
     * A review belongs to a tour package.
     */
    public function package()
    {
        return $this->belongsTo(TourPackage::class);
    }
}
