<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TourPackage extends Model
{
    protected $table = 'tour_packages';

    protected $fillable = [
        'title',
        'slug',
        'description',
        'price',
        'category_id',
        'sub_category_id',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class);
    }

    // Front-end images relation
    public function images()
    {
        return $this->hasMany(\App\Models\PackageImage::class, 'package_id');
    }

    /**
     * Package has many package itineraries (per-day itineraries)
     */
    public function itineraries()
    {
        return $this->hasMany(\App\Models\PackageItinerary::class, 'package_id')->orderBy('day_number');
    }

    /**
     * Package has many activities through package itineraries.
     * Activities table stores itinerary_id that references package_itineraries.id
     */
    public function activities()
    {
        return $this->hasManyThrough(
            \App\Models\Activity::class,
            \App\Models\PackageItinerary::class,
            'package_id', // Foreign key on PackageItinerary table...
            'itinerary_id', // Foreign key on Activity table...
            'id', // Local key on TourPackage
            'id' // Local key on PackageItinerary
        );
    }

    /**
     * Single inclution record (stores JSON list)
     */
    public function inclution()
    {
        return $this->hasOne(\App\Models\Inclution::class, 'package_id');
    }

    /**
     * Single exclution record (stores JSON list)
     */
    public function exclution()
    {
        return $this->hasOne(\App\Models\Exclution::class, 'package_id');
    }

    /**
     * Package reviews
     */
    public function reviews()
    {
        return $this->hasMany(\App\Models\Review::class, 'package_id');
    }
}
