<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'two_factor_expires_at' => 'datetime',
        ];
    }




    // User model attributes
    public function generateOtp()
    {
        $otp = rand(100000, 999999);
        $this->two_factor_otp = bcrypt($otp);
        $this->two_factor_expires_at = now()->addMinutes(5);
        $this->save();

        return $otp;
    }

    // Verify the OTP
    public function verifyOtp($otp)
    {
        $isValid = Hash::check($otp, $this->two_factor_otp) && now()->lt($this->two_factor_expires_at);

        if ($isValid) {
            $this->two_factor_otp = null;
            $this->two_factor_expires_at = null;
            $this->save();
        }

        return $isValid;
    }
}
