<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VideoGallery extends Model
{
    use HasFactory;

    protected $table = 'video_galleries';

    protected $fillable = [
        'title',
        'video_url',
        'category_id',
    ];

    // Relationship: A video belongs to a category
    public function category()
    {
        return $this->belongsTo(GalleryCategory::class, 'category_id');
    }
}
