<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
            $table->string('user_name');
            $table->float('ratings', 2, 1); // e.g. 4.5
            $table->text('comments')->nullable();
            $table->string('status')->default('pending'); // pending, approved, etc.
            $table->unsignedBigInteger('package_id');
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('package_id')
                  ->references('id')
                  ->on('tour_packages')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};
