<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('user_name');
            $table->unsignedBigInteger('package_id');
            $table->integer('num_people');
            $table->date('expected_date');
            $table->string('country')->nullable();
            $table->string('mobile');
            $table->string('email');
            $table->text('special_req')->nullable();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('package_id')
                  ->references('id')
                  ->on('tour_packages')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
