<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('itinerary_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('package_itinerary_id'); // FK from package_itineraries
            $table->string('image_path');
            $table->string('caption')->nullable();
            $table->integer('day_number')->nullable();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('package_itinerary_id')
                  ->references('id')
                  ->on('package_itineraries')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('itinerary_images');
    }
};
