<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('itineraries', function (Blueprint $table) {
            $table->id();
            $table->text('detail');
            $table->integer('order')->default(0);
            $table->unsignedBigInteger('package_itinerary_id'); // FK from package_itineraries
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('package_itinerary_id')
                  ->references('id')
                  ->on('package_itineraries')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('itineraries');
    }
};
