<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inclutions', function (Blueprint $table) {
            $table->id();
            $table->text('inclution'); // inclusion details
            $table->unsignedBigInteger('package_id');
            $table->timestamps();

            // Foreign key to tour_packages
            $table->foreign('package_id')
                  ->references('id')
                  ->on('tour_packages')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inclutions');
    }
};
