@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | ADMIN IMAGE GALLERY')
@section('content_admin')

    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Image Gallery</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Image Gallery</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        {{ session('success') }}
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-ban"></i> Error!</h5>
                        {{ session('error') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h4 class="card-title">Image Gallery Management</h4>
                                <div class="card-tools">
                                    <a href="{{ route('image-gallery.create') }}" class="btn btn-primary">
                                        <i class="fas fa-plus"></i> Add New Image
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Filter Controls -->
                                <div>
                                    <div class="btn-group w-100 mb-2">
                                        <a class="btn btn-info active" href="javascript:void(0)" data-filter="all">
                                            All Images ({{ $images->count() }})
                                        </a>
                                        @foreach ($categories as $category)
                                            <a class="btn btn-info" href="javascript:void(0)"
                                                data-filter="{{ $category->id }}">
                                                {{ $category->name }} ({{ $category->images->count() }})
                                            </a>
                                        @endforeach
                                    </div>
                                    <div class="mb-2">
                                        <a class="btn btn-secondary" href="javascript:void(0)" data-shuffle>
                                            Shuffle Images
                                        </a>
                                        <div class="float-right">
                                            <select class="custom-select" style="width: auto;" data-sortOrder>
                                                <option value="index"> Sort by Position </option>
                                                <option value="sortData"> Sort by Title </option>
                                            </select>
                                            <div class="btn-group">
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortAsc> Ascending
                                                </a>
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortDesc>
                                                    Descending </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Image Gallery Grid -->
                                <div>
                                    <div class="filter-container p-0 row">
                                        @foreach ($images as $image)
                                            <div class="filtr-item col-sm-2 mb-3" data-category="{{ $image->category_id }}"
                                                data-sort="{{ $image->title }}">
                                                <div class="image-container position-relative">
                                                    <a href="{{ Storage::url($image->image_path) }}" data-toggle="lightbox"
                                                        data-title="{{ $image->title }} - {{ $image->category->name }}"
                                                        data-gallery="gallery">
                                                        <img src="{{ Storage::url($image->image_path) }}"
                                                            class="img-fluid mb-2 gallery-image" alt="{{ $image->title }}"
                                                            style="height: 150px; object-fit: cover; width: 100%;">
                                                    </a>
                                                    <div class="image-actions position-absolute top-0 right-0 p-1">
                                                        <a href="{{ route('image-gallery.edit', $image->id) }}"
                                                            class="btn btn-warning btn-xs" title="Edit">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <form action="{{ route('image-gallery.destroy', $image->id) }}"
                                                            method="POST" style="display: inline-block;"
                                                            onsubmit="return confirm('Are you sure you want to delete this image: {{ $image->title }}? This action cannot be undone!')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-xs"
                                                                title="Delete">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                    <div class="image-info">
                                                        <small
                                                            class="text-muted d-block">{{ Str::limit($image->title, 20) }}</small>
                                                        <small
                                                            class="badge badge-info">{{ $image->category->name }}</small>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach

                                        @if ($images->isEmpty())
                                            <div class="col-12 text-center py-5">
                                                <i class="fas fa-images fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No images found in the gallery.</p>
                                                <a href="{{ route('image-gallery.create') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Image
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <style>
        .image-container {
            transition: transform 0.3s ease;
        }

        .image-container:hover {
            transform: scale(1.05);
        }

        .image-actions {
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .image-container:hover .image-actions {
            opacity: 1;
        }

        .gallery-image {
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .filtr-item {
            margin-bottom: 20px;
        }
    </style>
@endsection
