@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | ALL DESTINATIONS')
@section('content_admin')
    <div class="content-wrapper">
        <!-- Content Header -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">All Destinations</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">All Destinations</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title"> <i class="fas fa-map-marked-alt mr-2"></i>Destinations Map</h3>
                                <div class="card-tools">
                                    <a href="{{ route('destinations_create') }}" class="btn btn-success btn-sm">
                                        <i class="fas fa-plus mr-1"></i> New Destination</a>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <div id="map" style="height: 500px; border-radius: 0 0 4px 4px;"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- Modal for Destination Details -->
        <div class="modal fade" id="destinationModal" tabindex="-1" role="dialog" aria-labelledby="destinationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content border-0 shadow-lg">

                    <!-- Header -->
                    <div class="modal-header bg-gradient-primary text-white">
                        <h5 class="modal-title" id="destinationModalLabel">
                            <i class="fas fa-info-circle mr-2"></i>Destination Details
                        </h5>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <!-- Body -->
                    <div class="modal-body p-0">
                        <div class="row no-gutters">
                            <!-- Left Side Info -->
                            <div class="col-md-6 p-4 bg-light">
                                <h4 id="modal-name" class="text-primary mb-3"></h4>

                                <!-- Address Box -->
                                <div class="info-box bg-white shadow-sm mb-3">
                                    <span class="info-box-icon bg-info text-white"><i
                                            class="fas fa-map-marker-alt"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text font-weight-bold">Address</span>
                                        <span id="modal-address" class="info-box-number text-dark"></span>
                                    </div>
                                </div>

                                <!-- Description Box -->
                                <div class="info-box bg-white shadow-sm mb-3">
                                    <span class="info-box-icon bg-purple text-white"><i class="fas fa-file-alt"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text font-weight-bold">Description</span>
                                        <span id="modal-description" class="info-box-number text-dark"
                                            style="font-size: 0.9rem;"></span>
                                    </div>
                                </div>

                                <!-- Key Points -->
                                <div class="card card-secondary shadow-sm">
                                    <div class="card-header bg-gradient-secondary">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-star mr-1"></i>Key Details
                                        </h5>
                                    </div>
                                    <div class="card-body p-2">
                                        <ul id="modal-key-points-list" class="list-group list-group-flush"></ul>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Side Image -->
                            <div class="col-md-6 p-0">
                                <div id="modal-image"
                                    class="h-100 d-flex align-items-center justify-content-center bg-light border-left">
                                    <img id="modal-image-src" src="" alt="Destination Image"
                                        class="img-fluid rounded shadow" style="max-height: 100%; object-fit: contain;">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer d-flex justify-content-between">
                        <div>
                            <a href="#" id="modal-edit-btn" class="btn btn-primary">
                                <i class="fas fa-edit mr-1"></i>Edit
                            </a>
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal"
                                id="modal-delete-btn">
                                <i class="fas fa-trash mr-1"></i>Delete
                            </button>
                        </div>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>

                </div>
            </div>
        </div>


        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-danger">
                        <h5 class="modal-title text-white" id="deleteModalLabel">
                            <i class="fas fa-exclamation-triangle mr-2"></i>Confirm Deletion
                        </h5>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete the destination "<strong
                                id="delete-destination-name"></strong>"?</p>
                        <p class="text-danger"><small>This action cannot be undone.</small></p>
                    </div>
                    <div class="modal-footer">
                        {{--  <form id="delete-form" method="POST" action="">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash mr-1"></i>Delete
                            </button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </form>  --}}

                        <form id="delete-form" method="POST" action="">
    @csrf
    @method('DELETE')
    <button type="submit" class="btn btn-danger">
        <i class="fas fa-trash mr-1"></i>Delete
    </button>
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
</form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <!-- Leaflet MarkerCluster CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.Default.css" />

    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Leaflet MarkerCluster JS -->
    <script src="https://unpkg.com/leaflet.markercluster@1.4.1/dist/leaflet.markercluster.js"></script>

    <style>
        /* Custom marker styles */
        .custom-marker {
            background: #fff;
            border: 5px solid;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        /* Custom popup styles */
        .leaflet-popup-content-wrapper {
            border-radius: 4px;
            box-shadow: 0 3px 14px rgba(0, 0, 0, 0.2);
        }

        .leaflet-popup-content {
            margin: 12px 15px;
            font-family: 'Source Sans Pro', sans-serif;
        }

        .custom-popup-title {
            font-size: 1.1rem;
            font-weight: bold;
            margin-bottom: 5px;
            color: #007bff;
        }

        .custom-popup-content {
            font-size: 0.9rem;
            margin-bottom: 5px;
        }

        .custom-popup-button {
            display: block;
            width: 100%;
            text-align: center;
            margin-top: 8px;
            padding: 4px 8px;
            background: #007bff;
            color: white;
            border-radius: 3px;
            text-decoration: none;
            font-size: 0.85rem;
        }

        .custom-popup-button:hover {
            background: #0056b3;
            color: white;
            text-decoration: none;
        }

        /* Info box styling for modal */
        .info-box {
            box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2);
            border-radius: .25rem;
        }

        /* Key points list styling */
        #modal-key-points-list li {
            padding: 8px 10px;
            border-bottom: 1px solid rgba(0, 0, 0, .125);
        }

        #modal-key-points-list li:last-child {
            border-bottom: none;
        }
    </style>

    <script>
        // Initialize Leaflet map with better styling
        var map = L.map('map', {
            center: [7.8731, 80.7718], // Centered on Sri Lanka
            zoom: 7,
            zoomControl: true
        });

        // Add a more visually appealing tile layer
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
            maxZoom: 18
        }).addTo(map);

        // Create marker cluster group for better visualization of multiple markers
        var markers = L.markerClusterGroup({
            chunkedLoading: true,
            maxClusterRadius: 50,
            spiderfyOnMaxZoom: true,
            showCoverageOnHover: true,
            zoomToBoundsOnClick: true
        });

        // Color palette for markers
        const markerColors = ['#007bff', '#28a745', '#dc3545', '#ffc107', '#6f42c1', '#fd7e14', '#20c997', '#e83e8c'];

        // Fetch destinations and add markers
        const destinations = @json($destinations);

        destinations.forEach(function(destination, index) {
            let latlng;
            try {
                const coords = JSON.parse(destination.map_url);
                if (coords.latitude && coords.longitude) {
                    latlng = L.latLng(coords.latitude, coords.longitude);
                } else {
                    return; // Skip if no valid coordinates
                }
            } catch (e) {
                return; // Skip if map_url is invalid JSON
            }

            // Assign a color from the palette (cycle through colors)
            const color = markerColors[index % markerColors.length];

            // Create a custom marker with color
            const customIcon = L.divIcon({
                className: 'custom-marker',
                html: `<div style="background: ${color}; width: 20px; height: 20px; border-radius: 50%; border: 2px solid white; display: flex; align-items: center; justify-content: center; color: white; font-size: 12px;">${index + 1}</div>`,
                iconSize: [30, 30],
                iconAnchor: [15, 15]
            });

            // Create marker with custom icon
            const marker = L.marker(latlng, {
                icon: customIcon
            });

            // Create popup content with better styling
            const popupContent = `
            <div>
                <div class="custom-popup-title">${destination.name}</div>
                <div class="custom-popup-content">
                    <strong>Address:</strong> ${destination.address || 'Not provided'}<br>
                    <strong>Description:</strong> ${destination.description ? destination.description.substring(0, 100) + '...' : 'Not provided'}
                </div>
                <a href="#" class="custom-popup-button" onclick="openDestinationModal(${destination.id})">View Details</a>
            </div>
        `;

            marker.bindPopup(popupContent);
            markers.addLayer(marker);

            // Add click event to show modal with full details
            marker.on('click', function() {
                populateModal(destination);
            });
        });

        // Add markers to map
        map.addLayer(markers);

        // Function to populate modal with destination details
        function populateModal(destination) {
            document.getElementById('modal-name').textContent = destination.name;
            document.getElementById('modal-address').textContent = destination.address || 'Not provided';
            document.getElementById('modal-description').textContent = destination.description || 'Not provided';

            // Handle key points
            const keyPointsList = document.getElementById('modal-key-points-list');
            keyPointsList.innerHTML = '';
            if (destination.key_points && Array.isArray(destination.key_points)) {
                destination.key_points.forEach(point => {
                    const li = document.createElement('li');
                    li.textContent = point;
                    li.className = 'list-group-item';
                    keyPointsList.appendChild(li);
                });
            } else {
                const li = document.createElement('li');
                li.textContent = 'No key points available';
                li.className = 'list-group-item text-muted';
                keyPointsList.appendChild(li);
            }

            // Handle image
            const imageElement = document.getElementById('modal-image-src');
            if (destination.image_path) {
                imageElement.src = '/storage/' + destination.image_path;
                imageElement.style.display = 'block';
                document.getElementById('modal-image').style.background = '#f8f9fa';
            } else {
                imageElement.style.display = 'none';
                document.getElementById('modal-image').innerHTML =
                    '<div class="text-muted"><i class="fas fa-image fa-5x"></i><p>No image available</p></div>';
            }

            // Set edit and delete button actions
            document.getElementById('modal-edit-btn').href = `/Admin-Edit-Destination/${destination.id}`;
            // Set data attributes on the delete trigger button (as attributes so jQuery .attr can read them)
            const modalDeleteBtn = document.getElementById('modal-delete-btn');
            if (modalDeleteBtn) {
                modalDeleteBtn.setAttribute('data-destination-id', destination.id);
                modalDeleteBtn.setAttribute('data-destination-name', destination.name);
                // Also update the delete form action immediately so it's ready even if user opens the delete modal quickly
                const deleteForm = document.getElementById('delete-form');
                if (deleteForm) deleteForm.action = `/Admin-Delete-Destination/${destination.id}`;
            }
            const deleteNameEl = document.getElementById('delete-destination-name');
            if (deleteNameEl) deleteNameEl.textContent = destination.name;

            // Show modal
            $('#destinationModal').modal('show');
        }

        // Function to open modal from popup (for the View Details button)
        function openDestinationModal(destinationId) {
            const destination = destinations.find(d => d.id === destinationId);
            if (destination) {
                populateModal(destination);
            }
        }

        // When delete modal is about to be shown, ensure the form action is set.
        // The event.relatedTarget may be missing if modal opened programmatically, so we also set action when user clicks the modal-delete-btn.

        // Clicking the delete button inside the details modal will set the action and then show the delete modal programmatically
        $('#modal-delete-btn').on('click', function(e) {
            e.preventDefault();
            const destinationId = $(this).attr('data-destination-id');
            const destinationName = $(this).attr('data-destination-name');
            const modal = $('#deleteModal');
            if (destinationName) modal.find('#delete-destination-name').text(destinationName);
            if (destinationId) modal.find('#delete-form').attr('action', `/Admin-Delete-Destination/${destinationId}`);
            // Show the delete modal and set relatedTarget by triggering via the button element
            modal.modal('show', { relatedTarget: this });
        });

        $('#deleteModal').on('show.bs.modal', function(event) {
            const button = $(event.relatedTarget); // Button that triggered the modal (may be undefined if opened programmatically)
            const modal = $(this);
            let destinationId = null;
            let destinationName = null;
            if (button && button.length) {
                // use attr to get raw data attributes
                destinationId = button.attr('data-destination-id');
                destinationName = button.attr('data-destination-name');
            }

            // If the handler did not receive data via the triggering button, try to read values already set in the modal/form
            if (!destinationName) {
                destinationName = modal.find('#delete-destination-name').text() || null;
            }
            if (!destinationId) {
                // try to parse it from the current form action if present
                const currentAction = modal.find('#delete-form').attr('action') || '';
                const m = currentAction.match(/Admin-Delete-Destination\/(\d+)/);
                if (m && m[1]) destinationId = m[1];
            }

            if (destinationName) modal.find('#delete-destination-name').text(destinationName);
            if (destinationId) modal.find('#delete-form').attr('action', `/Admin-Delete-Destination/${destinationId}`);
        });
    </script>
@endsection
