@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | CREATE DESTINATION')
@section('content_admin')
    <div class="content-wrapper">
        <!-- Content Header -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create Destination</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Create Destination</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Add New Destination</h3>
                            </div>
                            <!-- Form -->
                            <form action="{{ route('destinations.store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="form-row">
                                        <!-- Name -->
                                        <div class="form-group col-md-6">
                                            <label for="name">Destination Name</label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                                id="name" name="name" value="{{ old('name') }}" required>
                                            @error('name')
                                                <span class="invalid-feedback">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <!-- Image -->
                                        <div class="form-group col-md-6">
                                            <label for="image">Destination Image</label>
                                            <div class="custom-file">
                                                <input type="file"
                                                    class="custom-file-input @error('image') is-invalid @enderror"
                                                    id="image" name="image">
                                                <label class="custom-file-label" for="image">Choose file</label>
                                            </div>
                                            @error('image')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <!-- Address -->
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="3">{{ old('address') }}</textarea>
                                        @error('address')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <!-- Map -->
                                    <div class="form-group">
                                        <label>Map Location</label>
                                        <div id="map"
                                            style="height: 300px; width: 100%; border: 1px solid #ced4da; border-radius: 4px;">
                                        </div>
                                        <input type="hidden" name="map_url" id="map_url" value="{{ old('map_url') }}">
                                        @error('map_url')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <!-- Description -->
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description"
                                            rows="4">{{ old('description') }}</textarea>
                                        @error('description')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <!-- Key Points -->
                                    <div class="form-group">
                                        <label for="key_points">Key Points (Enter each point on a new line)</label>
                                        <textarea class="form-control @error('key_points') is-invalid @enderror" id="key_points" name="key_points"
                                            rows="3">{{ old('key_points') }}</textarea>
                                        @error('key_points')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Card Footer -->
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary float-left">Create Destination</button>
                                    <a href="{{ route('dashboard') }}" class="btn btn-secondary float-right">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Leaflet CSS & JS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

    <script>
        // Initialize Leaflet map
        var map = L.map('map').setView([7.8731, 80.7718], 7); // Centered on Sri Lanka
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);

        // Marker for selecting location
        var marker = null;
        var latlng = null;

        // On map click, place or move marker and update map_url
        map.on('click', function(e) {
            latlng = e.latlng;
            if (marker) {
                marker.setLatLng(latlng);
            } else {
                marker = L.marker(latlng).addTo(map);
            }
            document.getElementById('map_url').value = JSON.stringify({
                latitude: latlng.lat,
                longitude: latlng.lng
            });
        });

        // Load existing map_url if available
        @if (old('map_url'))
            var savedLocation = JSON.parse('{{ old('map_url') }}');
            if (savedLocation.latitude && savedLocation.longitude) {
                latlng = L.latLng(savedLocation.latitude, savedLocation.longitude);
                marker = L.marker(latlng).addTo(map);
                map.setView(latlng, 10);
                document.getElementById('map_url').value = JSON.stringify(savedLocation);
            }
        @endif
    </script>
@endsection
