@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | EDIT DESTINATION')
@section('content_admin')
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Destination</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('destinations_all') }}">All Destinations</a></li>
                        <li class="breadcrumb-item active">Edit Destination</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Update Destination</h3>
                        </div>

                        <!-- Form -->
                        <form action="{{ route('destinations.update', $destination->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <!-- Name -->
                                <div class="form-group">
                                    <label for="name">Destination Name</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                        id="name" name="name" value="{{ old('name', $destination->name) }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Address -->
                                <div class="form-group">
                                    <label for="address">Address</label>
                                    <textarea class="form-control @error('address') is-invalid @enderror"
                                        id="address" name="address" rows="4">{{ old('address', $destination->address) }}</textarea>
                                    @error('address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Map (Fixed) -->
                                <div class="form-group">
                                    <label>Map Location</label>
                                    <div id="map" style="height: 400px;"></div>
                                    <input type="hidden" name="map_url" id="map_url" value="{{ old('map_url', $destination->map_url) }}">
                                    @error('map_url')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Description -->
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror"
                                        id="description" name="description" rows="6">{{ old('description', $destination->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Key Points -->
                                <div class="form-group">
                                    <label for="key_points">Key Points (Enter each point on a new line)</label>
                                    <textarea class="form-control @error('key_points') is-invalid @enderror"
                                        id="key_points" name="key_points" rows="4">{{ old('key_points', implode("\n", $destination->key_points ?? [])) }}</textarea>
                                    @error('key_points')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Image -->
                                <div class="form-group">
                                    <label for="image">Destination Image</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input @error('image') is-invalid @enderror"
                                                id="image" name="image">
                                            <label class="custom-file-label" for="image">Choose file</label>
                                        </div>
                                    </div>
                                    @if($destination->image_path)
                                        <div class="mt-2">
                                            <img src="{{ '/storage/' . $destination->image_path }}" alt="Current Image" style="max-width: 200px;">
                                        </div>
                                    @endif
                                    @error('image')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Card Footer -->
                            <div class="card-footer text-right">
                                <button type="submit" class="btn btn-primary">Update Destination</button>
                                <a href="{{ route('destinations_all') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Leaflet CSS & JS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    var map = L.map('map').setView([7.8731, 80.7718], 7);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    // Ensure the hidden input exists before using it
    const mapInput = document.getElementById('map_url');
    // Helper to safely parse JSON or return null
    function safeParse(json) {
        try {
            return JSON.parse(json);
        } catch (e) {
            return null;
        }
    }

    // Try to load old value first (old input), then fallback to model value
    let savedLocation = null;
    const oldRaw = '{{ old('map_url') }}';
    if (oldRaw && oldRaw !== '') {
        savedLocation = safeParse(oldRaw) || savedLocation;
    }
    if (!savedLocation) {
        // blade will print the model map_url (which may be JSON or empty)
        savedLocation = safeParse('{!! addslashes($destination->map_url ?? '') !!}') || null;
    }

    // Marker state
    let marker = null;

    function setMapInput(latlng) {
        if (!mapInput) return;
        mapInput.value = JSON.stringify({ latitude: latlng.lat, longitude: latlng.lng });
    }

    // Place existing marker if there's a saved location
    if (savedLocation && savedLocation.latitude && savedLocation.longitude) {
        const latlng = L.latLng(savedLocation.latitude, savedLocation.longitude);
        marker = L.marker(latlng, { draggable: true }).addTo(map);
        map.setView(latlng, 10);
        setMapInput(latlng);

        // update hidden input on drag
        marker.on('dragend', function(e) {
            const pos = e.target.getLatLng();
            setMapInput(pos);
        });
    }

    // Clicking the map adds or moves the marker
    map.on('click', function(e) {
        const latlng = e.latlng;
        if (marker) {
            marker.setLatLng(latlng);
        } else {
            marker = L.marker(latlng, { draggable: true }).addTo(map);
            marker.on('dragend', function(e) {
                const pos = e.target.getLatLng();
                setMapInput(pos);
            });
        }
        setMapInput(latlng);
    });

    // Optional reset button to restore original model location
    const resetBtn = document.getElementById('reset-map');
    if (resetBtn) {
        const original = safeParse('{!! addslashes($destination->map_url ?? '') !!}');
        resetBtn.addEventListener('click', function(e) {
            e.preventDefault();
            if (original && original.latitude && original.longitude) {
                const latlng = L.latLng(original.latitude, original.longitude);
                if (marker) {
                    marker.setLatLng(latlng);
                } else {
                    marker = L.marker(latlng, { draggable: true }).addTo(map);
                    marker.on('dragend', function(e) {
                        const pos = e.target.getLatLng();
                        setMapInput(pos);
                    });
                }
                map.setView(latlng, 10);
                setMapInput(latlng);
            } else {
                // No original location: remove marker and clear input
                if (marker) {
                    map.removeLayer(marker);
                    marker = null;
                }
                if (mapInput) mapInput.value = '';
                map.setView([7.8731, 80.7718], 7);
            }
        });
    }
</script>
@endsection
