@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | EDIT GALLERY IMAGE')
@section('content_admin')

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Edit Gallery Image</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('image-gallery.index') }}">Image Gallery</a></li>
                            <li class="breadcrumb-item active">Edit Image</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-8">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Edit Image Information</h3>
                            </div>
                            <form action="{{ route('image-gallery.update', $imageGallery->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="title">Image Title</label>
                                        <input type="text" class="form-control @error('title') is-invalid @enderror"
                                            id="title" name="title" placeholder="Enter image title"
                                            value="{{ old('title', $imageGallery->title) }}" required>
                                        @error('title')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="category_id">Category</label>
                                        <select class="form-control @error('category_id') is-invalid @enderror"
                                            id="category_id" name="category_id" required>
                                            <option value="">Select Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}"
                                                    {{ old('category_id', $imageGallery->category_id) == $category->id ? 'selected' : '' }}>
                                                    {{ $category->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label>Current Image</label>
                                        <div>
                                            <img src="{{ Storage::url($imageGallery->image_path) }}"
                                                alt="{{ $imageGallery->title }}"
                                                style="max-width: 300px; max-height: 200px; border-radius: 5px;">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="image">New Image (Leave empty to keep current)</label>
                                        <div class="custom-file">
                                            <input type="file"
                                                class="custom-file-input @error('image') is-invalid @enderror"
                                                id="image" name="image">
                                            <label class="custom-file-label" for="image">Choose new image file</label>
                                            @error('image')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <small class="form-text text-muted">
                                            Supported formats: JPEG, PNG, JPG, GIF, WEBP. Max size: 2MB
                                        </small>
                                    </div>

                                    <div class="form-group">
                                        <div id="image-preview" class="mt-2" style="display: none;">
                                            <img id="preview-img" src="#" alt="Image preview"
                                                style="max-width: 300px; max-height: 200px; border-radius: 5px;">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Update Image</button>
                                    <a href="{{ route('image-gallery.index') }}" class="btn btn-default">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

@endsection

@section('scripts')
    <script>
        // Image preview functionality
        document.getElementById('image').addEventListener('change', function(e) {
            const preview = document.getElementById('preview-img');
            const previewContainer = document.getElementById('image-preview');
            const file = e.target.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                }

                reader.readAsDataURL(file);

                // Update file label
                const fileName = document.getElementById('image').files[0].name;
                const nextSibling = e.target.nextElementSibling;
                nextSibling.innerText = fileName;
            }
        });
    </script>
@endsection
