@extends('layouts.admin')
@section('title', 'Manage Package Inclusions / Exclusions')

@section('content_admin')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Manage Images, Inclusions & Exclusions - {{ $package->title }}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('packages.index') }}">Tour Packages</a></li>
                            <li class="breadcrumb-item active">Manage</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        @if (session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Images</h3>
                                <div class="card-tools">
                                    <a href="{{ route('packages.images', $package->id) }}" class="btn btn-primary btn-sm">
                                        <i class="fas fa-plus"></i> Add New Images, Inclusions & Exclusions
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <p class="text-muted">Showing up to 4 images for this package. To add or manage images,
                                    use the "Add New Images, Inclusions & Exclusions" button at the top.</p>

                                <div class="row mb-3">
                                    @php $displayImages = $images->take(4); @endphp
                                    @if ($displayImages->isEmpty())
                                        <div class="col-12">
                                            <p class="text-muted">No images uploaded yet.</p>
                                        </div>
                                    @else
                                        @foreach ($displayImages as $img)
                                            <div class="col-md-3 mb-3">
                                                <div style="border:1px solid #e3e3e3; padding:8px; text-align:center;">
                                                    <img src="{{ asset($img->image_path) }}" alt="image"
                                                        style="max-width:100%; height:120px; object-fit:cover;" />
                                                    @if ($img->caption)
                                                        <p class="mt-2"><strong>{{ $img->caption }}</strong></p>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>Inclusions</h5>
                                        @if (!empty($inclusions) && count($inclusions))
                                            <ul class="list-group">
                                                @foreach ($inclusions as $inc)
                                                    <li class="list-group-item">{{ $inc }}</li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <p class="text-muted">No inclusions specified.</p>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <h5>Exclusions</h5>
                                        @if (!empty($exclusions) && count($exclusions))
                                            <ul class="list-group">
                                                @foreach ($exclusions as $exc)
                                                    <li class="list-group-item">{{ $exc }}</li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <p class="text-muted">No exclusions specified.</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <a href="{{ route('packages.index') }}" class="btn btn-secondary">Back</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>
    </div>

    <!-- No JS required for display-only view -->
@endsection
