@extends('layouts.admin')

@section('title', 'CEYLON THARU TRAVELS | MANAGE INCLUSIONS/EXCLUSIONS/IMAGES')

@section('content_admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Manage Inclusions/Exclusions/Images for {{ $package->title ?? 'Tour Package' }}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('packages.index') }}">Tour Packages</a></li>
                            <li class="breadcrumb-item active">Inclusions/Exclusions/Images</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Manage Inclusions/Exclusions/Images</h3>
                                <div class="card-tools">
                                    <a href="{{ route('packages.index') }}" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-arrow-left"></i> Back to Tour Packages
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Tab Navigation -->
                                <ul class="nav nav-tabs mb-4" id="packageTabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="inclusions-exclusions-tab" data-toggle="tab" href="#inclusions-exclusions" role="tab" aria-controls="inclusions-exclusions" aria-selected="true">
                                            <i class="fas fa-list"></i> Inclusions/Exclusions
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="package-images-tab" data-toggle="tab" href="#package-images" role="tab" aria-controls="package-images" aria-selected="false">
                                            <i class="fas fa-images"></i> Package Images
                                        </a>
                                    </li>
                                </ul>

                                <!-- Tab Content -->
                                <div class="tab-content" id="packageTabsContent">
                                    <!-- Inclusions/Exclusions Tab -->
                                    <div class="tab-pane fade show active" id="inclusions-exclusions" role="tabpanel" aria-labelledby="inclusions-exclusions-tab">
                                        @if (session('success'))
                                            <div class="alert alert-success alert-dismissible">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <h5><i class="icon fas fa-check"></i> Success!</h5>
                                                {{ session('success') }}
                                            </div>
                                        @endif

                                        @if (session('error'))
                                            <div class="alert alert-danger alert-dismissible">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <h5><i class="icon fas fa-ban"></i> Error!</h5>
                                                {{ session('error') }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <h5><i class="icon fas fa-ban"></i> Validation Error!</h5>
                                                <ul class="mb-0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        @if (!$package)
                                            <div class="alert alert-danger">
                                                <h5><i class="icon fas fa-ban"></i> Error!</h5>
                                                Tour package not found.
                                            </div>
                                        @else
                                            <form id="inclusion-exclusion-form" action="{{ route('packages.images.store', $package->id) }}" method="POST" enctype="multipart/form-data">
                                                @csrf
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <h4 class="text-primary">Inclusions and Exclusions</h4>
                                                        <div id="entry-fields">
                                                            <div class="entry-field mb-4 p-3 border rounded">
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <label class="font-weight-bold">Inclusion</label>
                                                                        <textarea name="inclusions[]" class="form-control @error('inclusions.*') is-invalid @enderror" rows="3" placeholder="Enter inclusion details...">{{ old('inclusions.0') }}</textarea>
                                                                        @error('inclusions.*')
                                                                            <span class="text-danger small">{{ $message }}</span>
                                                                        @enderror
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="font-weight-bold">Exclusion</label>
                                                                        <textarea name="exclusions[]" class="form-control @error('exclusions.*') is-invalid @enderror" rows="3" placeholder="Enter exclusion details...">{{ old('exclusions.0') }}</textarea>
                                                                        @error('exclusions.*')
                                                                            <span class="text-danger small">{{ $message }}</span>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                                <div class="mt-2">
                                                                    <button type="button" class="btn btn-danger btn-sm remove-entry">
                                                                        <i class="fas fa-trash"></i> Remove
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <button type="button" class="btn btn-success btn-sm mb-4" id="add-entry">
                                                            <i class="fas fa-plus"></i> Add More Entry
                                                        </button>
                                                    </div>
                                                </div>

                                                <!-- Existing Inclusions/Exclusions -->
                                                <div class="row">
                                                    @if ($package->inclusions && $package->inclusions->isNotEmpty())
                                                        <div class="col-md-6">
                                                            <div class="card card-success">
                                                                <div class="card-header">
                                                                    <h4 class="card-title">
                                                                        <i class="fas fa-check-circle"></i> Current Inclusions
                                                                    </h4>
                                                                </div>
                                                                <div class="card-body">
                                                                    <ul class="list-group list-group-flush">
                                                                        @foreach ($package->inclusions as $inclusion)
                                                                            <li class="list-group-item">
                                                                                <i class="fas fa-plus text-success mr-2"></i>{{ $inclusion->inclusion }}
                                                                            </li>
                                                                        @endforeach
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif

                                                    @if ($package->exclusions && $package->exclusions->isNotEmpty())
                                                        <div class="col-md-6">
                                                            <div class="card card-danger">
                                                                <div class="card-header">
                                                                    <h4 class="card-title">
                                                                        <i class="fas fa-times-circle"></i> Current Exclusions
                                                                    </h4>
                                                                </div>
                                                                <div class="card-body">
                                                                    <ul class="list-group list-group-flush">
                                                                        @foreach ($package->exclusions as $exclusion)
                                                                            <li class="list-group-item">
                                                                                <i class="fas fa-minus text-danger mr-2"></i>{{ $exclusion->exclusion }}
                                                                            </li>
                                                                        @endforeach
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>

                                                <div class="form-group text-center mt-4">
                                                    <button type="submit" class="btn btn-primary btn-lg px-5">
                                                        <i class="fas fa-save"></i> Save Inclusions/Exclusions
                                                    </button>
                                                    <a href="{{ route('packages.index') }}" class="btn btn-secondary btn-lg px-5 ml-3">
                                                        <i class="fas fa-times"></i> Cancel
                                                    </a>
                                                </div>
                                            </form>
                                        @endif
                                    </div>

                                    <!-- Package Images Tab -->
                                    <div class="tab-pane fade" id="package-images" role="tabpanel" aria-labelledby="package-images-tab">
                                        <form id="image-form" action="{{ route('packages.images.store', $package->id) }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h4 class="text-primary">Package Images <small class="text-muted">(Maximum 4 images)</small></h4>
                                                    <div id="image-fields">
                                                        <div class="image-field mb-4 p-3 border rounded bg-light">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <label class="font-weight-bold">
                                                                        <i class="fas fa-image"></i> Image
                                                                    </label>
                                                                    <input type="file" name="images[]" class="form-control-file @error('images.*') is-invalid @enderror" accept="image/jpeg,image/png,image/jpg,image/gif">
                                                                    <small class="text-muted">Supported: JPEG, PNG, JPG, GIF (Max: 2MB)</small>
                                                                    @error('images.*')
                                                                        <div class="text-danger small">{{ $message }}</div>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <label class="font-weight-bold">
                                                                        <i class="fas fa-pen"></i> Caption
                                                                    </label>
                                                                    <input type="text" name="captions[]" class="form-control @error('captions.*') is-invalid @enderror" placeholder="Enter image caption..." value="{{ old('captions.0') }}">
                                                                    <small class="text-muted">Optional description for the image</small>
                                                                    @error('captions.*')
                                                                        <div class="text-danger small">{{ $message }}</div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            <div class="mt-2">
                                                                <button type="button" class="btn btn-danger btn-sm remove-image">
                                                                    <i class="fas fa-trash"></i> Remove
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn btn-success btn-sm mb-4" id="add-image">
                                                        <i class="fas fa-plus"></i> Add Image
                                                    </button>
                                                    <div class="alert alert-info">
                                                        <i class="fas fa-info-circle"></i> You can upload up to 4 images for this package. Each image can have an optional caption.
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Existing Images -->
                                            @if ($package->images && $package->images->isNotEmpty())
                                                <div class="row mt-4">
                                                    <div class="col-12">
                                                        <div class="card card-info">
                                                            <div class="card-header">
                                                                <h4 class="card-title">
                                                                    <i class="fas fa-images"></i> Current Package Images
                                                                </h4>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    @foreach ($package->images as $image)
                                                                        <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                                                            <div class="card h-100">
                                                                                <img src="{{ asset($image->image_path) }}" class="card-img-top" alt="Package Image" style="height: 200px; object-fit: cover;">
                                                                                <div class="card-body p-2">
                                                                                    <p class="card-text small text-center">
                                                                                        {{ $image->caption ?? 'No caption provided' }}
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif

                                            <div class="form-group text-center mt-4">
                                                <button type="submit" class="btn btn-primary btn-lg px-5">
                                                    <i class="fas fa-save"></i> Save Images
                                                </button>
                                                <a href="{{ route('packages.index') }}" class="btn btn-secondary btn-lg px-5 ml-3">
                                                    <i class="fas fa-times"></i> Cancel
                                                </a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                console.log('DOM loaded, initializing form handlers');
                
                let entryCount = 1;
                let imageCount = 1;
                const maxImages = 4;

                // Add Entry (Inclusion and Exclusion)
                const addEntryButton = document.getElementById('add-entry');
                if (addEntryButton) {
                    addEntryButton.addEventListener('click', function () {
                        console.log('Adding new entry');
                        const entryFields = document.getElementById('entry-fields');
                        const newField = document.createElement('div');
                        newField.className = 'entry-field mb-4 p-3 border rounded';
                        newField.innerHTML = `
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="font-weight-bold">Inclusion</label>
                                    <textarea name="inclusions[]" class="form-control" rows="3" placeholder="Enter inclusion details..."></textarea>
                                </div>
                                <div class="col-md-6">
                                    <label class="font-weight-bold">Exclusion</label>
                                    <textarea name="exclusions[]" class="form-control" rows="3" placeholder="Enter exclusion details..."></textarea>
                                </div>
                            </div>
                            <div class="mt-2">
                                <button type="button" class="btn btn-danger btn-sm remove-entry">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        `;
                        entryFields.appendChild(newField);
                        entryCount++;
                    });
                }

                // Add Image field
                const addImageButton = document.getElementById('add-image');
                if (addImageButton) {
                    addImageButton.addEventListener('click', function () {
                        if (imageCount >= maxImages) {
                            alert('Maximum ' + maxImages + ' images allowed per package');
                            return;
                        }
                        
                        console.log('Adding new image field');
                        const imageFields = document.getElementById('image-fields');
                        const newField = document.createElement('div');
                        newField.className = 'image-field mb-4 p-3 border rounded bg-light';
                        newField.innerHTML = `
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="font-weight-bold">
                                        <i class="fas fa-image"></i> Image
                                    </label>
                                    <input type="file" name="images[]" class="form-control-file" accept="image/jpeg,image/png,image/jpg,image/gif">
                                    <small class="text-muted">Supported: JPEG, PNG, JPG, GIF (Max: 2MB)</small>
                                </div>
                                <div class="col-md-6">
                                    <label class="font-weight-bold">
                                        <i class="fas fa-pen"></i> Caption
                                    </label>
                                    <input type="text" name="captions[]" class="form-control" placeholder="Enter image caption...">
                                    <small class="text-muted">Optional description for the image</small>
                                </div>
                            </div>
                            <div class="mt-2">
                                <button type="button" class="btn btn-danger btn-sm remove-image">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        `;
                        imageFields.appendChild(newField);
                        imageCount++;
                        
                        // Update add button text
                        if (imageCount >= maxImages) {
                            addImageButton.disabled = true;
                            addImageButton.innerHTML = '<i class="fas fa-ban"></i> Maximum Images Reached';
                        }
                    });
                }

                // Remove Entry
                document.addEventListener('click', function (e) {
                    if (e.target.classList.contains('remove-entry') || e.target.closest('.remove-entry')) {
                        console.log('Removing entry');
                        const button = e.target.classList.contains('remove-entry') ? e.target : e.target.closest('.remove-entry');
                        button.closest('.entry-field').remove();
                        entryCount--;
                    }
                });

                // Remove Image
                document.addEventListener('click', function (e) {
                    if (e.target.classList.contains('remove-image') || e.target.closest('.remove-image')) {
                        console.log('Removing image field');
                        const button = e.target.classList.contains('remove-image') ? e.target : e.target.closest('.remove-image');
                        button.closest('.image-field').remove();
                        imageCount--;
                        
                        // Re-enable add button if under limit
                        if (imageCount < maxImages) {
                            addImageButton.disabled = false;
                            addImageButton.innerHTML = '<i class="fas fa-plus"></i> Add Image';
                        }
                    }
                });

                // Form submission validation for Inclusions/Exclusions
                const inclusionForm = document.getElementById('inclusion-exclusion-form');
                if (inclusionForm) {
                    inclusionForm.addEventListener('submit', function (e) {
                        console.log('Inclusions/Exclusions form being submitted');
                        
                        const inclusions = Array.from(document.querySelectorAll('textarea[name="inclusions[]"]'));
                        const exclusions = Array.from(document.querySelectorAll('textarea[name="exclusions[]"]'));
                        const hasInclusions = inclusions.some(input => input.value.trim() !== '');
                        const hasExclusions = exclusions.some(input => input.value.trim() !== '');
                        
                        if (!hasInclusions && !hasExclusions) {
                            e.preventDefault();
                            alert('Please add at least one inclusion or exclusion before saving.');
                            return false;
                        }
                        
                        const submitBtn = inclusionForm.querySelector('button[type="submit"]');
                        const originalText = submitBtn.innerHTML;
                        submitBtn.disabled = true;
                        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
                        
                        setTimeout(() => {
                            submitBtn.disabled = false;
                            submitBtn.innerHTML = originalText;
                        }, 5000);
                    });
                }

                // Form submission validation for Images
                const imageForm = document.getElementById('image-form');
                if (imageForm) {
                    imageForm.addEventListener('submit', function (e) {
                        console.log('Images form being submitted');
                        
                        const images = Array.from(document.querySelectorAll('input[name="images[]"]'));
                        const hasImages = images.some(input => input.files && input.files.length > 0);
                        
                        if (!hasImages) {
                            e.preventDefault();
                            alert('Please add at least one image before saving.');
                            return false;
                        }
                        
                        const submitBtn = imageForm.querySelector('button[type="submit"]');
                        const originalText = submitBtn.innerHTML;
                        submitBtn.disabled = true;
                        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
                        
                        setTimeout(() => {
                            submitBtn.disabled = false;
                            submitBtn.innerHTML = originalText;
                        }, 5000);
                    });
                }

                // File input preview and validation
                document.addEventListener('change', function(e) {
                    if (e.target.type === 'file' && e.target.accept.includes('image')) {
                        const file = e.target.files[0];
                        if (file) {
                            console.log('Image selected:', file.name, 'Size:', Math.round(file.size/1024) + 'KB');
                            
                            if (file.size > 2048 * 1024) {
                                alert('Image file is too large. Maximum size is 2MB.');
                                e.target.value = '';
                                return;
                            }
                        }
                    }
                });
            });
        </script>

@endsection