{{--  @extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | PACKAGE INQUIRIES')
@section('content_admin')


    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>All Package Inquiries</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        {{ session('success') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Inquiry Management</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>User Name</th>
                                    <th>Package</th>
                                    <th>Number of People</th>
                                    <th>Expected Date</th>
                                    <th>Country</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Special Requests</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bookings as $booking)
                                    <tr>
                                        <td>{{ $booking->user_name }}</td>
                                        <td>{{ $booking->package ? $booking->package->name : 'N/A' }}</td>
                                        <td>{{ $booking->num_people }}</td>
                                        <td>{{ $booking->expected_date }}</td>
                                        <td>{{ $booking->country }}</td>
                                        <td>{{ $booking->mobile }}</td>
                                        <td>{{ $booking->email }}</td>
                                        <td>{{ $booking->special_req ?? 'None' }}</td>
                                        <td>
                                            <form action="{{ route('inquiries.destroy', $booking->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this inquiry?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>


@endsection  --}}


@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | PACKAGE INQUIRIES')
@section('content_admin')

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>All Package Inquiries</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        {{ session('success') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Inquiry Management</h3>
                    </div>
                    <div class="card-body">
                        <table id="inquiries-table" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>User Name</th>
                                    <th>Package</th>
                                    <th>Number of People</th>
                                    <th>Expected Date</th>
                                    <th>Country</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Special Requests</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bookings as $booking)
                                    <tr>
                                        <td>{{ $booking->user_name }}</td>
                                        <td>{{ $booking->package->title }}</td>
                                        <td>{{ $booking->num_people }}</td>
                                        <td>{{ $booking->expected_date }}</td>
                                        <td>{{ $booking->country }}</td>
                                        <td>
                                            <a href="tel:{{ $booking->mobile }}">{{ $booking->mobile }}</a>
                                        </td>
                                        <td>
                                            <a href="mailto:{{ $booking->email }}">{{ $booking->email }}</a>
                                        </td>
                                        <td>{{ $booking->special_req ?? 'None' }}</td>
                                        <td>
                                            <form action="{{ route('inquiries.destroy', $booking->id) }}" method="POST"
                                                style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this inquiry?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- DataTables CSS & JS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#inquiries-table').DataTable({
                responsive: true,
                pageLength: 10,
                order: [
                    [3, 'asc']
                ] // order by Expected Date
            });
        });
    </script>

@endsection
