@extends('layouts.admin')

@section('title', 'CEYLON THARU TRAVELS | CREATE ITINERARY')

@section('content_admin')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Create Itinerary for {{ $package->title }}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('packages.index') }}">Packages</a></li>
                            <li class="breadcrumb-item"><a
                                    href="{{ route('packages.itineraries', $package->id) }}">Itineraries</a></li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        {{ session('success') }}
                    </div>
                @endif

                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Add New Itinerary</h3>
                    </div>
                    <form action="{{ route('packages.itineraries.store', $package->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <label for="day_number">Day Number</label>
                                <select name="day_number" id="day_number" class="form-control" required>
                                    @for ($i = 1; $i <= 10; $i++)
                                        <option value="{{ $i }}">{{ $i }}</option>
                                    @endfor
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control" required>
                                @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="map_url">Location</label>
                                <div id="map" style="height: 300px;"></div>
                                <input type="hidden" name="map_url" id="map_url" class="form-control">
                                @error('map_url')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Images (up to 3)</label>
                                <div class="row">
                                    @for ($i = 0; $i < 3; $i++)
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="image_{{ $i }}">Image {{ $i + 1 }}</label>
                                                <input type="file" name="images[]" id="image_{{ $i }}"
                                                    class="form-control-file" accept="image/*">
                                                @error('images.' . $i)
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label for="caption_{{ $i }}">Caption (optional)</label>
                                                <input type="text" name="captions[]" id="caption_{{ $i }}"
                                                    class="form-control">
                                            </div>
                                        </div>
                                    @endfor
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Add Itinerary</button>
                            <a href="{{ route('packages.itineraries', $package->id) }}"
                                class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>


    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
        // Initialize map for adding new itinerary
        var map = L.map('map').setView([0, 0], 2);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);

        var marker = L.marker([0, 0]).addTo(map);
        var coordinates = {
            lat: 0,
            lng: 0
        };

        map.on('click', function(e) {
            coordinates = e.latlng;
            marker.setLatLng(coordinates);
            document.getElementById('map_url').value = JSON.stringify(coordinates);
        });
    </script>
@endsection
