@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | ADMIN VIDEO GALLERY')
@section('content_admin')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Video Gallery</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Video Gallery</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        {{ session('success') }}
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-ban"></i> Error!</h5>
                        {{ session('error') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h4 class="card-title">Video Gallery Management</h4>
                                <div class="card-tools">
                                    <a href="{{ route('video-gallery.create') }}" class="btn btn-primary">
                                        <i class="fas fa-plus"></i> Add New Video
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Filter Controls -->
                                <div>
                                    <div class="btn-group w-100 mb-2">
                                        <a class="btn btn-info active" href="javascript:void(0)" data-filter="all">
                                            All Videos ({{ $videos->count() }})
                                        </a>
                                        @foreach ($categories as $category)
                                            <a class="btn btn-info" href="javascript:void(0)"
                                                data-filter="{{ $category->id }}">
                                                {{ $category->name }} ({{ $category->videos->count() }})
                                            </a>
                                        @endforeach
                                    </div>
                                    <div class="mb-2">
                                        <a class="btn btn-secondary" href="javascript:void(0)" data-shuffle>
                                            Shuffle Videos
                                        </a>
                                        <div class="float-right">
                                            <select class="custom-select" style="width: auto;" data-sortOrder>
                                                <option value="index"> Sort by Position </option>
                                                <option value="sortData"> Sort by Title </option>
                                            </select>
                                            <div class="btn-group">
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortAsc> Ascending
                                                </a>
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortDesc>
                                                    Descending </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{--  <!-- Video Gallery Grid -->
                                <div>
                                    <div class="filter-container p-0 row">
                                        @foreach ($videos as $video)
                                            <div class="filtr-item col-sm-6 col-md-4 col-lg-3 mb-4"
                                                data-category="{{ $video->category_id }}" data-sort="{{ $video->title }}">
                                                <div class="video-card card">
                                                    <div class="video-thumbnail position-relative">


                                                        <video controls class="card-img-top"
                                                            style="max-width: 100%; max-height: 200px;  object-fit: cover;"">
                                                            <source src="{{ asset('storage/' . $video->video_url) }}"
                                                                type="video/mp4">
                                                            Your browser does not support the video tag.
                                                        </video>
                                                        <div
                                                            class="play-button position-absolute top-50 start-50 translate-middle">
                                                            <i class="fas fa-play-circle fa-3x text-white"
                                                                style="opacity: 0.8;"></i>
                                                        </div>
                                                        <div class="video-actions position-absolute top-0 end-0 p-2">
                                                            <a href="{{ route('video-gallery.edit', $video->id) }}"
                                                                class="btn btn-warning btn-xs" title="Edit">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                                                                                   <form
                                                                action="{{ route('video-gallery.destroy', $category->id) }}"
                                                                method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger btn-sm"
                                                                    onclick="return confirm('Are you sure you want to delete this category?')">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </form>

                                                        </div>
                                                    </div>
                                                    <div class="card-body">


                                                        <div class="video-type-badge mt-2">
                                                            <span class="badge badge-primary"><i class="fas fa-upload"></i>
                                                                {{ $video->category->name }}</span>
                                                                  <h6 class="card-title">{{ Str::limit($video->title, 30) }}</h6>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        @endforeach

                                        @if ($videos->isEmpty())
                                            <div class="col-12 text-center py-5">
                                                <i class="fas fa-video fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No videos found in the gallery.</p>
                                                <a href="{{ route('video-gallery.create') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Video
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>  --}}
                                <!-- Video Gallery Grid -->
                                <div>
                                    <div class="filter-container p-0 row">
                                        @foreach ($videos as $video)
                                            <div class="filtr-item col-sm-6 col-md-4 col-lg-3 mb-4"
                                                data-category="{{ $video->category_id }}" data-sort="{{ $video->title }}">
                                                <div class="card h-100 shadow-sm">

                                                    <!-- Video Thumbnail -->
                                                    <div class="position-relative">
                                                        <video controls class="card-img-top"
                                                            style="max-height: 200px; object-fit: cover; border-top-left-radius: .25rem; border-top-right-radius: .25rem;">
                                                            <source src="{{ asset('storage/' . $video->video_url) }}"
                                                                type="video/mp4">
                                                            Your browser does not support the video tag.
                                                        </video>
                                                        <div class="position-absolute top-50 start-50 translate-middle">
                                                            <i class="fas fa-play-circle fa-3x text-white"
                                                                style="opacity: 0.8;"></i>
                                                        </div>
                                                    </div>
                                                    <br>

                                                    <!-- Card Body -->
                                                    <div class="card-body">
                                                        <span class="badge bg-primary mb-2">
                                                            <i class="fas fa-folder"></i> {{ $video->category->name }}
                                                        </span>
                                                      <br>  <h6 class="card-title">{{ Str::limit($video->title, 40) }}</h6>
                                                    </div>

                                                    <!-- Card Footer (Actions) -->
                                                    <div class="card-footer text-end">
                                                        <a href="{{ route('video-gallery.edit', $video->id) }}"
                                                            class="btn btn-warning btn-sm">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <form action="{{ route('video-gallery.destroy', $video->id) }}"
                                                            method="POST" class="d-inline">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm"
                                                                onclick="return confirm('Are you sure you want to delete this video?')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>

                                                </div>
                                            </div>
                                        @endforeach

                                        @if ($videos->isEmpty())
                                            <div class="col-12 text-center py-5">
                                                <i class="fas fa-video fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No videos found in the gallery.</p>
                                                <a href="{{ route('video-gallery.create') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Video
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

    <!-- Video Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="videoModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="videoModalLabel">Video Preview</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <div id="video-player"></div>
                </div>
            </div>
        </div>
    </div>
@endsection
