{{--  @extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | ADD VIDEO TO GALLERY')
@section('content_admin')

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add New Video to Gallery</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('video-gallery.index') }}">Video Gallery</a></li>
                        <li class="breadcrumb-item active">Add Video</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Video Information</h3>
                        </div>
                        <form action="{{ route('video-gallery.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Video Title</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                           id="title" name="title" placeholder="Enter video title"
                                           value="{{ old('title') }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select class="form-control @error('category_id') is-invalid @enderror"
                                            id="category_id" name="category_id" required>
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="video_type">Video Source</label>
                                    <select class="form-control @error('video_type') is-invalid @enderror"
                                            id="video_type" name="video_type" required>
                                        <option value="">Select Video Source</option>
                                        <option value="upload" {{ old('video_type') == 'upload' ? 'selected' : '' }}>Upload Video File</option>
                                        <option value="youtube" {{ old('video_type') == 'youtube' ? 'selected' : '' }}>YouTube URL</option>
                                        <option value="external" {{ old('video_type') == 'external' ? 'selected' : '' }}>External Video URL</option>
                                    </select>
                                    @error('video_type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <!-- Upload Video File Field -->
                                <div class="form-group video-upload-field" style="display: none;">
                                    <label for="video_file">Video File</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('video_file') is-invalid @enderror"
                                               id="video_file" name="video_file">
                                        <label class="custom-file-label" for="video_file">Choose video file</label>
                                        @error('video_file')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <small class="form-text text-muted">
                                        Supported formats: MP4, AVI, MOV, WMV, WEBM. Max size: 50MB
                                    </small>
                                    <div id="video-preview" class="mt-2" style="display: none;">
                                        <video id="preview-video" controls style="max-width: 100%; max-height: 200px;">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>
                                </div>

                                <!-- YouTube URL Field -->
                                <div class="form-group youtube-url-field" style="display: none;">
                                    <label for="youtube_url">YouTube URL</label>
                                    <input type="url" class="form-control @error('youtube_url') is-invalid @enderror"
                                           id="youtube_url" name="youtube_url"
                                           placeholder="https://www.youtube.com/watch?v=..."
                                           value="{{ old('youtube_url') }}">
                                    @error('youtube_url')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    <small class="form-text text-muted">
                                        Enter the full YouTube video URL
                                    </small>
                                </div>

                                <!-- External URL Field -->
                                <div class="form-group external-url-field" style="display: none;">
                                    <label for="external_url">External Video URL</label>
                                    <input type="url" class="form-control @error('external_url') is-invalid @enderror"
                                           id="external_url" name="external_url"
                                           placeholder="https://example.com/video.mp4"
                                           value="{{ old('external_url') }}">
                                    @error('external_url')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    <small class="form-text text-muted">
                                        Enter the direct URL to the video file
                                    </small>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Video</button>
                                <a href="{{ route('video-gallery.index') }}" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Show/hide fields based on video type selection
        $('#video_type').change(function() {
            const videoType = $(this).val();

            // Hide all fields first
            $('.video-upload-field, .youtube-url-field, .external-url-field').hide();
            $('.video-upload-field input, .youtube-url-field input, .external-url-field input').prop('required', false);

            // Show relevant field
            if (videoType === 'upload') {
                $('.video-upload-field').show();
                $('#video_file').prop('required', true);
            } else if (videoType === 'youtube') {
                $('.youtube-url-field').show();
                $('#youtube_url').prop('required', true);
            } else if (videoType === 'external') {
                $('.external-url-field').show();
                $('#external_url').prop('required', true);
            }
        });

        // Trigger change on page load if there's old input
        @if(old('video_type'))
            $('#video_type').trigger('change');
        @endif

        // Video file preview
        $('#video_file').change(function(e) {
            const file = e.target.files[0];
            const preview = $('#preview-video')[0];
            const previewContainer = $('#video-preview');

            if (file) {
                const url = URL.createObjectURL(file);
                preview.src = url;
                previewContainer.show();

                // Update file label
                const fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').text(fileName);
            }
        });
    });
</script>
@endsection  --}}




@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | ADD VIDEO TO GALLERY')
@section('content_admin')

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add New Video to Gallery</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('video-gallery.index') }}">Video Gallery</a></li>
                        <li class="breadcrumb-item active">Add Video</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Video Information</h3>
                        </div>
                        <form action="{{ route('video-gallery.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="video_type" value="upload">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Video Title</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                           id="title" name="title" placeholder="Enter video title"
                                           value="{{ old('title') }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select class="form-control @error('category_id') is-invalid @enderror"
                                            id="category_id" name="category_id" required>
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <!-- Upload Video File Field -->
                                <div class="form-group video-upload-field">
                                    <label for="video_file">Video File</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('video_file') is-invalid @enderror"
                                               id="video_file" name="video_file" required>
                                        <label class="custom-file-label" for="video_file">Choose video file</label>
                                        @error('video_file')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <small class="form-text text-muted">
                                        Supported formats: MP4, AVI, MOV, WMV, FLV. Max size: 50MB
                                    </small>
                                    <div id="video-preview" class="mt-2" style="display: none;">
                                        <video id="preview-video" controls style="max-width: 100%; max-height: 200px;">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>
                                </div>

                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Video</button>
                                <a href="{{ route('video-gallery.index') }}" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Video file preview
        $('#video_file').change(function(e) {
            const file = e.target.files[0];
            const preview = $('#preview-video')[0];
            const previewContainer = $('#video-preview');

            if (file) {
                const url = URL.createObjectURL(file);
                preview.src = url;
                previewContainer.show();

                // Update file label
                const fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').text(fileName);
            }
        });
    });
</script>
@endsection
