@extends('layouts.admin')
@section('title', 'CEYLON THARU TRAVELS | EDIT GALLERY VIDEO')
@section('content_admin')

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit Gallery Video</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('video-gallery.index') }}">Video Gallery</a></li>
                        <li class="breadcrumb-item active">Edit Video</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Edit Video Information</h3>
                        </div>
                        <form action="{{ route('video-gallery.update', $videoGallery->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="video_type" value="upload">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Video Title</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                           id="title" name="title" placeholder="Enter video title"
                                           value="{{ old('title', $videoGallery->title) }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select class="form-control @error('category_id') is-invalid @enderror"
                                            id="category_id" name="category_id" required>
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category_id', $videoGallery->category_id) == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <!-- Current Video Preview -->
                                <div class="form-group">
                                    <label>Current Video</label>
                                    <div class="current-video-preview">
                                        <video controls style="max-width: 100%; max-height: 200px;">
                                            <source src="{{ asset('storage/' . $videoGallery->video_url) }}" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>
                                </div>

                                <!-- Upload Video File Field (to replace) -->
                                <div class="form-group video-upload-field">
                                    <label for="video_file">New Video File (optional)</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input @error('video_file') is-invalid @enderror"
                                               id="video_file" name="video_file">
                                        <label class="custom-file-label" for="video_file">Choose new video file</label>
                                        @error('video_file')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <small class="form-text text-muted">
                                        Supported formats: MP4, AVI, MOV, WMV, FLV. Max size: 50MB. Leave empty to keep current video.
                                    </small>
                                    <div id="video-preview" class="mt-2" style="display: none;">
                                        <video id="preview-video" controls style="max-width: 100%; max-height: 200px;">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>
                                </div>

                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Update Video</button>
                                <a href="{{ route('video-gallery.index') }}" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Video file preview
        $('#video_file').change(function(e) {
            const file = e.target.files[0];
            const preview = $('#preview-video')[0];
            const previewContainer = $('#video-preview');

            if (file) {
                const url = URL.createObjectURL(file);
                preview.src = url;
                previewContainer.show();

                // Update file label
                const fileName = $(this).val().split('\\').pop();
                $(this).next('.custom-file-label').text(fileName);
            }
        });
    });
</script>
@endsection
