@extends('layouts.front')

@section('title', 'Forgot Password - Ceylon Tharu Tours')

@section('content')
    <style>
        .auth-page {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 80vh;
            background: #f9f9f9;
            padding: 20px;
        }

        .auth-wrapper {
            width: 100%;
            max-width: 420px;
        }

        .auth-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .auth-header {
            background: #0077b6;
            color: #fff;
            text-align: center;
            padding: 15px;
        }

        .auth-body {
            padding: 25px;
        }

        .auth-info {
            font-size: 14px;
            color: #555;
        }

        .auth-group {
            margin-bottom: 18px;
        }

        .auth-label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
        }

        .auth-input {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
        }

        .auth-input.is-invalid {
            border-color: #dc3545;
        }

        .auth-error {
            font-size: 13px;
            color: #dc3545;
            margin-top: 5px;
        }

        .auth-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 15px;
        }

        .auth-btn {
            background: #0077b6;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            color: #fff;
            cursor: pointer;
            transition: 0.3s;
        }

        .auth-btn:hover {
            background: #005f86;
        }

        .auth-alert.success {
            background: #d1e7dd;
            color: #0f5132;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
        }

        .auth-extra {
            text-align: center;
            padding: 15px;
            background: #f1f1f1;
            font-size: 14px;
        }

        .auth-extra a {
            color: #0077b6;
            font-weight: 600;
            text-decoration: none;
        }

        .auth-extra a:hover {
            text-decoration: underline;
        }
    </style>
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height:200px;">
            <h3 class="text-white display-3 mb-4">Forgot Password</h1>
                <ol class="breadcrumb justify-content-center mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active text-white">Forgot Password</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->
    <div class="auth-page">
        <div class="auth-wrapper">
            <div class="auth-card">
                <div class="auth-header">
                    <h4>Forgot Password</h4>
                </div>
                <div class="auth-body">

                    <!-- Info Text -->
                    <div class="auth-info mb-3">
                        {{ __('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}
                    </div>

                    <!-- Session Status -->
                    @if (session('status'))
                        <div class="auth-alert success mb-3">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf

                        <!-- Email -->
                        <div class="auth-group mb-3">
                            <label for="email" class="auth-label">{{ __('Email Address') }}</label>
                            <input id="email" type="email" class="auth-input @error('email') is-invalid @enderror"
                                name="email" value="{{ old('email') }}" required autofocus>
                            @error('email')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Submit Button -->
                        <div class="auth-footer">
                            <button type="submit" class="auth-btn">
                                {{ __('Email Password Reset Link') }}
                            </button>
                        </div>
                    </form>
                </div>

                <div class="auth-extra">
                    <a href="{{ route('login') }}">{{ __('Back to Login') }}</a>
                </div>
            </div>
        </div>
    </div>
@endsection
