@extends('layouts.front')

@section('title', 'Login - Ceylon Tharu Tours')

@section('content')
    <style>
        .auth-page {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 80vh;
            background: #f9f9f9;
            padding: 20px;
        }

        .auth-wrapper {
            width: 100%;
            max-width: 420px;
        }

        .auth-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .auth-header {
            background: #0077b6;
            /* tourism theme blue */
            color: #fff;
            text-align: center;
            padding: 15px;
        }

        .auth-body {
            padding: 25px;
        }

        .auth-group {
            margin-bottom: 18px;
        }

        .auth-label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
        }

        .auth-input {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
        }

        .auth-input.is-invalid {
            border-color: #dc3545;
        }

        .auth-error {
            font-size: 13px;
            color: #dc3545;
            margin-top: 5px;
        }

        .auth-check {
            display: flex;
            align-items: center;
            gap: 6px;
            margin-bottom: 20px;
        }

        .auth-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .auth-btn {
            background: #0077b6;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            color: #fff;
            cursor: pointer;
            transition: 0.3s;
        }

        .auth-btn:hover {
            background: #005f86;
        }

        .auth-link {
            font-size: 14px;
            color: #0077b6;
            text-decoration: none;
        }

        .auth-link:hover {
            text-decoration: underline;
        }

        .auth-alert.success {
            background: #d1e7dd;
            color: #0f5132;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
        }

        .auth-extra {
            text-align: center;
            padding: 15px;
            background: #f1f1f1;
            font-size: 14px;
        }

        .auth-extra a {
            color: #0077b6;
            font-weight: 600;
            margin-left: 5px;
        }
    </style>
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height:200px;">
            <h3 class="text-white display-3 mb-4">Admin Login</h1>
                <ol class="breadcrumb justify-content-center mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active text-white">Admin Login</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->
    <div class="auth-page">
        <div class="auth-wrapper">
            <div class="auth-card">
                <div class="auth-header">
                    <h4>Login as Admin</h4>
                </div>
                <div class="auth-body">

                    <!-- Session Status -->
                    @if (session('status'))
                        <div class="auth-alert success">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <!-- Email -->
                        <div class="auth-group">
                            <label for="email" class="auth-label">{{ __('Email Address') }}</label>
                            <input id="email" type="email" class="auth-input @error('email') is-invalid @enderror"
                                name="email" value="{{ old('email') }}" required autofocus autocomplete="username">
                            @error('email')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Password -->
                        <div class="auth-group">
                            <label for="password" class="auth-label">{{ __('Password') }}</label>
                            <input id="password" type="password" class="auth-input @error('password') is-invalid @enderror"
                                name="password" required autocomplete="current-password">
                            @error('password')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Remember Me -->
                        <div class="auth-check">
                            <input type="checkbox" id="remember_me" name="remember">
                            <label for="remember_me">{{ __('Remember Me') }}</label>
                        </div>

                        <!-- Submit & Forgot Password -->
                        <div class="auth-footer">
                            @if (Route::has('password.request'))
                                <a class="auth-link" href="{{ route('password.request') }}">
                                    {{ __('Forgot your password?') }}
                                </a>
                            @endif

                            <button type="submit" class="auth-btn">
                                {{ __('Log in') }}
                            </button>
                        </div>
                    </form>
                </div>

                {{--  <div class="auth-extra">
                <span>{{ __("Don't have an account?") }}</span>
                <a href="{{ route('register') }}">{{ __('Register') }}</a>
            </div>  --}}
            </div>
        </div>
    </div>
@endsection
