@extends('layouts.front')

@section('title', 'Reset Password - Ceylon Tharu Tours')

@section('content')
    <style>
        /* Wrapper for auth pages */
        .auth-page {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 80vh;
            background: #f9f9f9;
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Center card wrapper */
        .auth-wrapper {
            width: 100%;
            max-width: 420px;
        }

        /* Card container */
        .auth-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        /* Card header */
        .auth-header {
            background: #0077b6;
            /* brand/tourism color */
            color: #fff;
            text-align: center;
            padding: 15px;
            font-size: 20px;
            font-weight: 600;
        }

        /* Card body */
        .auth-body {
            padding: 25px;
        }

        /* Info text for forgot-password */
        .auth-info {
            font-size: 14px;
            color: #555;
            margin-bottom: 18px;
        }

        /* Form group wrapper */
        .auth-group {
            margin-bottom: 18px;
        }

        /* Form label */
        .auth-label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
            color: #333;
        }

        /* Input fields */
        .auth-input {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            transition: 0.3s;
        }

        .auth-input:focus {
            outline: none;
            border-color: #0077b6;
            box-shadow: 0 0 5px rgba(0, 119, 182, 0.3);
        }

        /* Validation error messages */
        .auth-input.is-invalid {
            border-color: #dc3545;
        }

        .auth-error {
            font-size: 13px;
            color: #dc3545;
            margin-top: 5px;
        }

        /* Remember me checkbox */
        .auth-check {
            display: flex;
            align-items: center;
            gap: 6px;
            margin-bottom: 20px;
        }

        /* Footer with button & links */
        .auth-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 15px;
        }

        /* Buttons */
        .auth-btn {
            background: #0077b6;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            color: #fff;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: 0.3s;
        }

        .auth-btn:hover {
            background: #005f86;
        }

        /* Alerts */
        .auth-alert.success {
            background: #d1e7dd;
            color: #0f5132;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-size: 14px;
        }

        /* Extra links at bottom (back to login / register) */
        .auth-extra {
            text-align: center;
            padding: 15px;
            background: #f1f1f1;
            font-size: 14px;
            border-top: 1px solid #e0e0e0;
        }

        .auth-extra a {
            color: #0077b6;
            font-weight: 600;
            text-decoration: none;
        }

        .auth-extra a:hover {
            text-decoration: underline;
        }

        /* Optional: Add a pulse animation for logo if used as preloader */
        @keyframes pulse {
            0% {
                transform: scale(1);
                opacity: 0.7;
            }

            50% {
                transform: scale(1.1);
                opacity: 1;
            }

            100% {
                transform: scale(1);
                opacity: 0.7;
            }
        }
    </style>
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height:200px;">
            <h3 class="text-white display-3 mb-4">Reset Password</h1>
                <ol class="breadcrumb justify-content-center mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active text-white">Reset Password</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->
    <div class="auth-page">
        <div class="auth-wrapper">
            <div class="auth-card">
                <div class="auth-header">
                    <h4>Reset Password</h4>
                </div>
                <div class="auth-body">

                    <!-- Session Status -->
                    @if (session('status'))
                        <div class="auth-alert success mb-3">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('password.store') }}">
                        @csrf

                        <!-- Password Reset Token -->
                        <input type="hidden" name="token" value="{{ $request->route('token') }}">

                        <!-- Email -->
                        <div class="auth-group mb-3">
                            <label for="email" class="auth-label">{{ __('Email Address') }}</label>
                            <input id="email" type="email" class="auth-input @error('email') is-invalid @enderror"
                                name="email" value="{{ old('email', $request->email) }}" required autofocus
                                autocomplete="username">
                            @error('email')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Password -->
                        <div class="auth-group mb-3">
                            <label for="password" class="auth-label">{{ __('Password') }}</label>
                            <input id="password" type="password" class="auth-input @error('password') is-invalid @enderror"
                                name="password" required autocomplete="new-password">
                            @error('password')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Confirm Password -->
                        <div class="auth-group mb-3">
                            <label for="password_confirmation" class="auth-label">{{ __('Confirm Password') }}</label>
                            <input id="password_confirmation" type="password"
                                class="auth-input @error('password_confirmation') is-invalid @enderror"
                                name="password_confirmation" required autocomplete="new-password">
                            @error('password_confirmation')
                                <div class="auth-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Submit Button -->
                        <div class="auth-footer">
                            <button type="submit" class="auth-btn">
                                {{ __('Reset Password') }}
                            </button>
                        </div>
                    </form>
                </div>

                <div class="auth-extra">
                    <a href="{{ route('login') }}">{{ __('Back to Login') }}</a>
                </div>
            </div>
        </div>
    </div>
@endsection
