<!-- Subscribe Start -->
<div class="container-fluid subscribe py-5">
    <div class="container text-center py-5">
        <div class="mx-auto text-center" style="max-width: 900px;">
            <h5 class="subscribe-title px-3">Subscribe</h5>
            <h1 class="text-white mb-4">Our Newsletter</h1>
            <p class="text-white mb-5">
                Stay updated with our latest news and offers.
            </p>

            <!-- Success / Error Messages -->
            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @elseif(session('error'))
                <div class="alert alert-danger">{{ session('error') }}</div>
            @endif

            <form action="{{ route('newsletter.store') }}" method="POST" class="position-relative mx-auto"
                style="max-width: 500px;">
                @csrf
                <input class="form-control border-primary rounded-pill w-100 py-3 ps-4 pe-5" type="email"
                    name="email" placeholder="Your email" required>
                <button type="submit"
                    class="btn btn-primary rounded-pill position-absolute top-0 end-0 py-2 px-4 mt-2 me-2">
                    Subscribe
                </button>
            </form>
        </div>
    </div>
</div>
<!-- Subscribe End -->


<!-- Footer Start -->
<div class="container-fluid footer py-5">
    <div class="container py-5">
        <div class="row g-5">
            <div class="col-md-6 col-lg-6 col-xl-3">
                <div class="footer-item d-flex flex-column">
                    <h4 class="mb-4 text-white">Get In Touch</h4>
                    <a href=""><i class="fas fa-home me-2"></i> 123 Street, New York, USA</a>
                    <a href=""><i class="fas fa-envelope me-2"></i> info@example.com</a>
                    <a href=""><i class="fas fa-phone me-2"></i> +012 345 67890</a>
                    <a href="" class="mb-3"><i class="fas fa-print me-2"></i> +012 345 67890</a>
                    <div class="d-flex align-items-center">
                        <i class="fas fa-share fa-2x text-white me-2"></i>
                        <a class="btn-square btn btn-primary rounded-circle mx-1" href=""><i
                                class="fab fa-facebook-f"></i></a>
                        <a class="btn-square btn btn-primary rounded-circle mx-1" href=""><i
                                class="fab fa-twitter"></i></a>
                        <a class="btn-square btn btn-primary rounded-circle mx-1" href=""><i
                                class="fab fa-instagram"></i></a>
                        <a class="btn-square btn btn-primary rounded-circle mx-1" href=""><i
                                class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3">
                <div class="footer-item d-flex flex-column">
                    <h4 class="mb-4 text-white">Links</h4>
                    <a href="{{ route('home') }}"><i class="fas fa-angle-right me-2"></i> Home</a>
                    <a href="{{ route('about') }}"><i class="fas fa-angle-right me-2"></i> About Us</a>
                    <a href="{{ route('destinations') }}"><i class="fas fa-angle-right me-2"></i> Destinations</a>
                    <a href="{{ route('packages') }}"><i class="fas fa-angle-right me-2"></i> Packages</a>
                    <a href="{{ route('contact') }}"><i class="fas fa-angle-right me-2"></i> Contact Us</a>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3">
                <div class="footer-item d-flex flex-column">
                    <h4 class="mb-4 text-white">Gallery</h4>
                    <a href="{{ route('video_gallery') }}"><i class="fas fa-angle-right me-2"></i> Videos</a>
                    <a href="{{ route('image_gallery') }}"><i class="fas fa-angle-right me-2"></i> Images</a>
                    <a href="{{ route('languages.all') }}"><i class="fas fa-angle-right me-2"></i> Language</a>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3">
                <!-- About Ceylon Tharu Travels -->
                <div class="footer-item">
                    <h4 class="text-white mb-3">About Ceylon Tharu Travels</h4>
                    <p class="text-white">
                        Discover Sri Lanka with Ceylon Tharu Travels. We offer personalized tours, blending culture,
                        history, and natural beauty for an unforgettable journey.
                    </p>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- Footer End -->

<!-- Copyright Start -->
<div class="container-fluid copyright text-body py-4">
    <div class="container">
        <div class="row g-4 align-items-center">
            <div class="col-md-6 text-center text-md-end mb-md-0">
                <i class="fas fa-copyright me-2"></i>
                <a class="text-white fw-bold" href="#">Ceylon Tharu Travels</a> — {{ date('Y') }}. All Rights
                Reserved.
            </div>
            {{--  <div class="col-md-6 text-center text-md-start">
                Design & Developed by
                <a class="text-white fw-bold" href="https://echobits.malsoftbits.com" target="_blank">Echobits</a>
            </div>  --}}
        </div>
    </div>
</div>
</div>
<!-- Copyright End -->

<!-- Back to Top -->
<a href="#" class="btn btn-primary btn-primary-outline-0 btn-md-square back-to-top"><i
        class="fa fa-arrow-up"></i></a>
