        <!-- Topbar Start -->
        <div class="container-fluid bg-primary px-5 d-none d-lg-block">
            <div class="row gx-0">
                <div class="col-lg-8 text-center text-lg-start mb-2 mb-lg-0">
                    <div class="d-inline-flex align-items-center" style="height: 45px;">
                        <a class="btn btn-sm btn-outline-light btn-sm-square rounded-circle me-2" href=""><i
                                class="fab fa-twitter fw-normal"></i></a>
                        <a class="btn btn-sm btn-outline-light btn-sm-square rounded-circle me-2" href=""><i
                                class="fab fa-facebook-f fw-normal"></i></a>
                        <a class="btn btn-sm btn-outline-light btn-sm-square rounded-circle me-2" href=""><i
                                class="fab fa-linkedin-in fw-normal"></i></a>
                        <a class="btn btn-sm btn-outline-light btn-sm-square rounded-circle me-2" href=""><i
                                class="fab fa-instagram fw-normal"></i></a>
                        <a class="btn btn-sm btn-outline-light btn-sm-square rounded-circle" href=""><i
                                class="fab fa-youtube fw-normal"></i></a>
                    </div>
                </div>

                <div class="col-lg-4 text-center text-lg-end">
                    <div class="d-inline-flex align-items-center" style="height: 45px;">
                        <!-- Email instead of Login/Register -->
                        <a href="mailto:info@yourdomain.com" class="me-3 text-light">
                            <small><i class="fa fa-envelope me-2"></i>info@yourdomain.com</small>
                        </a>

                        <!-- Language Switcher Dropdown -->
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle text-light" data-bs-toggle="dropdown">
                                <small><i class="fa fa-language me-2"></i> Language</small>
                            </a>
                            <div class="dropdown-menu rounded" id="languageDropdown">
                                <a href="#" class="dropdown-item" onclick="changeLanguage('en')">🇺🇸 English</a>
                                <a href="#" class="dropdown-item" onclick="changeLanguage('si')">🇱🇰 Sinhala</a>
                                <a href="#" class="dropdown-item" onclick="changeLanguage('ta')">🇮🇳 Tamil</a>
                                <a href="#" class="dropdown-item" onclick="changeLanguage('fr')">🇫🇷 French</a>
                                <a href="#" class="dropdown-item" onclick="changeLanguage('de')">🇩🇪 German</a>
                                <a href="{{ route('languages.all') }}" class="dropdown-item">
                                    🌍 View All Languages
                                </a>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- Topbar End -->
        <!-- Styles: adjust to match Phoenix card look -->
        <style>
            /* Wrapper looks like a compact Phoenix card */
            .phoenix-translate {
                display: inline-block;
                font-family: "Inter", "Helvetica Neue", Arial, sans-serif;
            }

            .phoenix-translate__inner {
                display: flex;
                align-items: center;
                gap: 0.75rem;
                padding: 0.375rem 0.7rem;
                {{--  background: #ffffff;  --}} border-radius: 12px;
                /* soft large radius like Phoenix */
                box-shadow: 0 6px 18px rgba(20, 24, 40, 0.06);
                border: 1px solid rgba(15, 23, 42, 0.04);
                min-height: 42px;
            }

            /* Label small, muted */
            .phoenix-translate__label {
                font-size: 12px;
                color: #6b7280;
                /* muted */
                font-weight: 600;
                letter-spacing: 0.02em;
            }

            /* Ensure Google widget sits inline and can be styled */
            .phoenix-translate__widget {
                display: inline-flex;
                align-items: center;
            }

            /* Restyled native select used by Google (goog-te-combo) */
            .phoenix-select,
            .phoenix-translate__widget select.goog-te-combo {
                appearance: none !important;
                -webkit-appearance: none !important;
                -moz-appearance: none !important;
                padding: 6px 28px 6px 10px !important;
                font-size: 13px !important;
                line-height: 1 !important;
                border-radius: 10px !important;
                border: 1px solid rgba(15, 23, 42, 0.08) !important;
                {{--  background: #4c545c url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="10" height="7" viewBox="0 0 10 7"><path fill="%23858" d="M5 7L0 0h10z"/></svg>') no-repeat right 10px center !important;  --}} background-size: 10px 7px !important;
                cursor: pointer !important;
            }

            /* Hide the "Google Translate" + "Powered by" text */
            .goog-te-gadget {
                font-size: 0 !important;
                color: transparent !important;
            }

            .goog-te-gadget span,
            .goog-te-gadget-simple span,
            .goog-logo-link {
                display: none !important;
            }

            /* Hide Google Translate top banner */
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }

            /* Prevent body from being pushed down when banner is hidden */
            body {
                top: 0 !important;
            }

            body>.skiptranslate {
                display: none;
            }

            /* Slightly smaller select on mobile */
            @media (max-width: 576px) {
                .phoenix-translate__inner {
                    padding: 0.3rem 0.5rem;
                }

                .phoenix-select {
                    font-size: 12px !important;
                    padding: 6px 24px 6px 8px !important;
                }
            }

            /* Prevent Google translate toolbar from covering UI */
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }

            body {
                top: 0 !important;
            }

            /* ensure page not shifted by translate banner */

            /* Keep the "powered by Google" link readable but subtle inside the gadget if it appears */
            .goog-logo-link {
                display: inline-block !important;
                opacity: 0.85;
            }

            .goog-te-gadget-simple {
                border: none !important;
                background: transparent !important;
            }

            /* Make the iframe menu appear above everything */
            .goog-te-menu-frame {
                z-index: 999999 !important;
                box-shadow: 0 12px 30px rgba(2, 6, 23, 0.15) !important;
                border-radius: 10px !important;
                overflow: hidden;
            }

            /* Small visual tweak for items inside the translate menu (inside iframe) — note: may require iframe CSS override which Google controls; these are best-effort */
            .goog-te-menu2 {
                font-family: "Inter", Arial, sans-serif !important;
            }
        </style>

        <!-- Google Translate -->
        <div id="google_translate_element" style="display:none;"></div>

        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({
                        pageLanguage: 'en',
                        includedLanguages: 'en,si,ta,fr,de',
                        autoDisplay: false
                    },
                    'google_translate_element'
                );
            }

            function changeLanguage(lang) {
                var frame = document.querySelector("iframe.goog-te-menu-frame");
                if (frame) {
                    var innerDoc = frame.contentDocument || frame.contentWindow.document;
                    var select = innerDoc.querySelector(".goog-te-menu2-item span[text='" + lang + "']");
                }
                var selectField = document.querySelector("select.goog-te-combo");
                if (selectField) {
                    selectField.value = lang;
                    selectField.dispatchEvent(new Event("change"));
                }
            }
        </script>

        <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
        </script>


        <!-- Navbar & Hero Start -->
        <div class="container-fluid position-relative p-0">
            <nav class="navbar navbar-expand-lg navbar-light px-4 px-lg-5 py-3 py-lg-0">
                <a href="{{ route('login') }}" class="navbar-brand p-0">
                    <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height:200px;">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarCollapse">
                    <span class="fa fa-bars"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarCollapse">
                    <div class="navbar-nav ms-auto py-0">
                        <a href="{{ route('home') }}"
                            class="nav-item nav-link {{ request()->routeIs('home') ? 'active' : '' }}">Home</a>
                        <a href="{{ route('about') }}"
                            class="nav-item nav-link {{ request()->routeIs('about') ? 'active' : '' }}">About Us</a>
                        <a href="{{ route('destinations') }}"
                            class="nav-item nav-link {{ request()->routeIs('destinations') ? 'active' : '' }}">Destinations</a>
                        <a href="{{ route('packages') }}"
                            class="nav-item nav-link {{ request()->routeIs('packages') ? 'active' : '' }}">Packages</a>
                        <div class="nav-item dropdown">
                            <a href="#"
                                class="nav-link dropdown-toggle {{ request()->routeIs(['video_gallery', 'image_gallery']) ? 'active' : '' }}"
                                data-bs-toggle="dropdown">Gallery</a>
                            <div class="dropdown-menu m-0">
                                <a href="{{ route('video_gallery') }}"
                                    class="dropdown-item {{ request()->routeIs('video_gallery') ? 'active' : '' }}">Videos</a>
                                <a href="{{ route('image_gallery') }}"
                                    class="dropdown-item {{ request()->routeIs('image_gallery') ? 'active' : '' }}">Images</a>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('contact') }}"
                        class="btn btn-primary rounded-pill py-2 px-4 ms-lg-4 {{ request()->routeIs('contact') ? 'active' : '' }}">Contact
                        Us</a>
                </div>
            </nav>


            <!-- Navbar & Hero End -->
