<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Contact Message</title>
    <style>
        /* Reset styles for email compatibility */
        body, html {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f7f9fc;
        }

        /* Main container */
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        /* Header section */
        .email-header {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }

        .email-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }

        .email-header p {
            margin: 10px 0 0;
            opacity: 0.9;
            font-size: 16px;
        }

        /* Content section */
        .email-content {
            padding: 30px;
        }

        .message-card {
            background-color: #f8f9fa;
            border-left: 4px solid #6a11cb;
            padding: 20px;
            border-radius: 0 8px 8px 0;
            margin-bottom: 25px;
        }

        .message-card p {
            margin: 0;
            font-style: italic;
            color: #555;
        }

        /* Info grid */
        .info-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 15px;
        }

        @media (min-width: 480px) {
            .info-grid {
                grid-template-columns: 1fr 1fr;
            }
        }

        .info-item {
            display: flex;
            flex-direction: column;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 8px;
        }

        .info-label {
            font-size: 14px;
            font-weight: 600;
            color: #6a11cb;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .info-value {
            font-size: 16px;
            color: #333;
        }

        /* Footer */
        .email-footer {
            background-color: #f1f3f4;
            padding: 20px;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .timestamp {
            margin-top: 10px;
            font-size: 12px;
            color: #888;
        }

        /* Action button */
        .action-button {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 25px;
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <h1>New Contact Message</h1>
            <p>You've received a new message through your website contact form</p>
        </div>

        <!-- Content -->
        <div class="email-content">
            <div class="message-card">
                <p>"{{ $data['message'] }}"</p>
            </div>

            <div class="info-grid">
                <div class="info-item">
                    <span class="info-label">Name</span>
                    <span class="info-value">{{ $data['name'] }}</span>
                </div>

                <div class="info-item">
                    <span class="info-label">Email</span>
                    <span class="info-value">{{ $data['email'] }}</span>
                </div>

                <div class="info-item">
                    <span class="info-label">Subject</span>
                    <span class="info-value">{{ $data['subject'] }}</span>
                </div>

                <div class="info-item">
                    <span class="info-label">Date Received</span>
                    <span class="info-value">{{ date('F j, Y, g:i a') }}</span>
                </div>
            </div>

            <a href="mailto:{{ $data['email'] }}?subject=Re: {{ $data['subject'] }}" class="action-button">Reply to {{ $data['name'] }}</a>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <p>This message was sent from your website contact form.</p>
            <div class="timestamp">Received on {{ date('F j, Y') }} at {{ date('g:i a') }}</div>
        </div>
    </div>
</body>
</html>
