@extends('layouts.front')
@section('title', 'CEYLON THARU TOURS | IMAGE GALLERY')

@section('content')
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h3 class="text-white display-3 mb-4">Our Gallery</h3>
            <ol class="breadcrumb justify-content-center mb-0">
                <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Pages</a></li>
                <li class="breadcrumb-item active text-white">Gallery</li>
            </ol>
        </div>
    </div>
    <!-- Header End -->

    <!-- Gallery Start -->
    <div class="container-fluid gallery py-5 my-5">
        <div class="mx-auto text-center mb-5" style="max-width: 900px;">
            <h5 class="section-title px-3">Our Gallery</h5>
            <h1 class="mb-4">Tourism & Traveling Gallery</h1>
            <p class="mb-0">Lorem ipsum dolor sit amet consectetur adipisicing elit. Laborum tempore nam, architecto
                doloremque velit explicabo? Voluptate sunt eveniet fuga eligendi! Expedita laudantium fugiat corrupti eum
                cum repellat a laborum quasi.</p>
        </div>
        <div class="tab-class text-center">
            <ul class="nav nav-pills d-inline-flex justify-content-center mb-5">
                <li class="nav-item">
                    <a class="d-flex mx-3 py-2 border border-primary bg-light rounded-pill active" data-bs-toggle="pill"
                        href="#GalleryTab-all">
                        <span class="text-dark" style="width: 150px;">All</span>
                    </a>
                </li>
                @foreach ($categories as $index => $category)
                    <li class="nav-item">
                        <a class="d-flex py-2 mx-3 border border-primary bg-light rounded-pill" data-bs-toggle="pill"
                            href="#GalleryTab-{{ $category->id }}">
                            <span class="text-dark" style="width: 150px;">{{ $category->name }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                <!-- All Images Tab -->
                <div id="GalleryTab-all" class="tab-pane fade show p-0 active">
                    <div class="row g-2">
                        @foreach ($images as $image)
                            <div
                                class="col-sm-6 col-md-6 col-lg-4 col-xl-{{ in_array($image->id % 10, [1, 3, 5, 8]) ? 2 : 3 }}">
                                <div class="gallery-item h-100">
                                    <img src="{{ asset('storage/' . $image->image_path) }}"
                                        class="img-fluid w-100 h-100 rounded" alt="{{ $image->title }}">
                                    <div class="gallery-content">
                                        <div class="gallery-info">
                                            <h5 class="text-white text-uppercase mb-2">{{ $image->category->name }}</h5>
                                            <div class="btn-hover text-white">{{ $image->title }} </div>
                                        </div>
                                    </div>
                                    <div class="gallery-plus-icon">
                                        <a href="{{ asset('storage/' . $image->image_path) }}"
                                            data-lightbox="gallery-{{ $image->id }}" class="my-auto"><i
                                                class="fas fa-plus fa-2x text-white"></i></a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <!-- Category-specific Tabs -->
                @foreach ($categories as $category)
                    <div id="GalleryTab-{{ $category->id }}" class="tab-pane fade show p-0">
                        <div class="row g-2">
                            @foreach ($images->where('category_id', $category->id) as $image)
                                <div
                                    class="col-sm-6 col-md-6 col-lg-4 col-xl-{{ in_array($image->id % 10, [1, 3, 5, 8]) ? 2 : 3 }}">
                                    <div class="gallery-item h-100">
                                        <img src="{{ asset('storage/' . $image->image_path) }}"
                                            class="img-fluid w-100 h-100 rounded" alt="{{ $image->title }}">
                                        <div class="gallery-content">
                                            <div class="gallery-info">
                                                <h5 class="text-white text-uppercase mb-2">{{ $category->name }}</h5>
                                                <div class="btn-hover text-white">{{ $image->title }} </div>
                                            </div>
                                        </div>
                                        <div class="gallery-plus-icon">
                                            <a href="{{ asset('storage/' . $image->image_path) }}"
                                                data-lightbox="gallery-{{ $image->id }}" class="my-auto"><i
                                                    class="fas fa-plus fa-2x text-white"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Gallery End -->
@endsection
