@extends('layouts.front')

@section('content')
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h3 class="text-white display-3 mb-4">Language Settings</h1>
                <ol class="breadcrumb justify-content-center mb-0">
                    <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pages</a></li>
                    <li class="breadcrumb-item active text-white">Language Settings</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->
    <div class="container py-5">
        <h2 class="mb-4">Choose Your Language</h2>
        <p>Select your preferred language to translate the website.</p>

        <!-- Google Translate Widget -->
        <div id="google_translate_element"></div>
    </div>


    <div class="phoenix-language-container">
        <!-- Search and controls -->
        <div class="language-controls">
            <!-- Phoenix-style search box -->
            <div class="search-box flex items-center border rounded px-3 py-2 w-full max-w-sm">
                <i class="uil uil-search text-gray-500 mr-2"></i>
                <input type="text" id="languageSearch" placeholder="Search languages..."
                    class="search-box flex items-center border rounded px-3 py-2 w-full max-w-sm">
            </div>


            <div class="selection-info">
                <span id="selectedCount" style="display: none;">0 selected</span>
                <button id="clearSelection" class="clear-btn">Clear</button>
            </div>
        </div>

        <!-- Language grid -->
        <div class="phoenix-language-grid" id="languageGrid">
            <!-- Languages will be populated here -->
        </div>

        <!-- Action buttons -->
        <div class="language-actions" style="display: none;">
            <button class="phoenix-btn phoenix-btn-primary" id="saveSelection">Save Selection</button>
            <button class="phoenix-btn phoenix-btn-secondary" id="selectAll">Select All</button>
        </div>
    </div>

    <!-- Hidden Google Translate container -->
    <div id="google_translate_element" style="display:none;"></div>

    <!-- Google Translate Script -->
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                autoDisplay: false
            }, 'google_translate_element');
        }

        // Language data structure
        const languages = [{
                code: 'en',
                name: 'English',
                native: 'English'
            },
            {
                code: 'si',
                name: 'Sinhala',
                native: 'සිංහල'
            },
            {
                code: 'ta',
                name: 'Tamil',
                native: 'தமிழ்'
            },
            {
                code: 'af',
                name: 'Afrikaans',
                native: 'Afrikaans'
            },
            {
                code: 'sq',
                name: 'Albanian',
                native: 'Shqip'
            },
            {
                code: 'am',
                name: 'Amharic',
                native: 'አማርኛ'
            },
            {
                code: 'ar',
                name: 'Arabic',
                native: 'العربية'
            },
            {
                code: 'hy',
                name: 'Armenian',
                native: 'Հայերեն'
            },
            {
                code: 'as',
                name: 'Assamese',
                native: 'অসমীয়া'
            },
            {
                code: 'ay',
                name: 'Aymara',
                native: 'Aymara'
            },
            {
                code: 'az',
                name: 'Azerbaijani',
                native: 'Azərbaycan'
            },
            {
                code: 'bm',
                name: 'Bambara',
                native: 'Bamanankan'
            },
            {
                code: 'eu',
                name: 'Basque',
                native: 'Euskara'
            },
            {
                code: 'be',
                name: 'Belarusian',
                native: 'Беларуская'
            },
            {
                code: 'bn',
                name: 'Bengali',
                native: 'বাংলা'
            },
            {
                code: 'bho',
                name: 'Bhojpuri',
                native: 'भोजपुरी'
            },
            {
                code: 'bs',
                name: 'Bosnian',
                native: 'Bosanski'
            },
            {
                code: 'bg',
                name: 'Bulgarian',
                native: 'Български'
            },
            {
                code: 'ca',
                name: 'Catalan',
                native: 'Català'
            },
            {
                code: 'ceb',
                name: 'Cebuano',
                native: 'Cebuano'
            },
            {
                code: 'ny',
                name: 'Chichewa',
                native: 'Chichewa'
            },
            {
                code: 'zh-CN',
                name: 'Chinese (Simplified)',
                native: '中文 (简体)'
            },
            {
                code: 'zh-TW',
                name: 'Chinese (Traditional)',
                native: '中文 (繁體)'
            },
            {
                code: 'co',
                name: 'Corsican',
                native: 'Corsu'
            },
            {
                code: 'hr',
                name: 'Croatian',
                native: 'Hrvatski'
            },
            {
                code: 'cs',
                name: 'Czech',
                native: 'Čeština'
            },
            {
                code: 'da',
                name: 'Danish',
                native: 'Dansk'
            },
            {
                code: 'dv',
                name: 'Dhivehi',
                native: 'ދިވެހި'
            },
            {
                code: 'doi',
                name: 'Dogri',
                native: 'डोगरी'
            },
            {
                code: 'nl',
                name: 'Dutch',
                native: 'Nederlands'
            },
            {
                code: 'eo',
                name: 'Esperanto',
                native: 'Esperanto'
            },
            {
                code: 'et',
                name: 'Estonian',
                native: 'Eesti'
            },
            {
                code: 'ee',
                name: 'Ewe',
                native: 'Ewe'
            },
            {
                code: 'fil',
                name: 'Filipino',
                native: 'Filipino'
            },
            {
                code: 'fi',
                name: 'Finnish',
                native: 'Suomi'
            },
            {
                code: 'fr',
                name: 'French',
                native: 'Français'
            },
            {
                code: 'fy',
                name: 'Frisian',
                native: 'Frysk'
            },
            {
                code: 'gl',
                name: 'Galician',
                native: 'Galego'
            },
            {
                code: 'ka',
                name: 'Georgian',
                native: 'ქართული'
            },
            {
                code: 'de',
                name: 'German',
                native: 'Deutsch'
            },
            {
                code: 'el',
                name: 'Greek',
                native: 'Ελληνικά'
            },
            {
                code: 'gn',
                name: 'Guarani',
                native: 'Avañe\'ẽ'
            },
            {
                code: 'gu',
                name: 'Gujarati',
                native: 'ગુજરાતી'
            },
            {
                code: 'ht',
                name: 'Haitian Creole',
                native: 'Kreyòl Ayisyen'
            },
            {
                code: 'ha',
                name: 'Hausa',
                native: 'Hausa'
            },
            {
                code: 'haw',
                name: 'Hawaiian',
                native: 'ʻŌlelo Hawaiʻi'
            },
            {
                code: 'he',
                name: 'Hebrew',
                native: 'עברית'
            },
            {
                code: 'hi',
                name: 'Hindi',
                native: 'हिन्दी'
            },
            {
                code: 'hmn',
                name: 'Hmong',
                native: 'Hmong'
            },
            {
                code: 'hu',
                name: 'Hungarian',
                native: 'Magyar'
            },
            {
                code: 'is',
                name: 'Icelandic',
                native: 'Íslenska'
            },
            {
                code: 'ig',
                name: 'Igbo',
                native: 'Igbo'
            },
            {
                code: 'ilo',
                name: 'Ilocano',
                native: 'Ilokano'
            },
            {
                code: 'id',
                name: 'Indonesian',
                native: 'Bahasa Indonesia'
            },
            {
                code: 'ga',
                name: 'Irish',
                native: 'Gaelige'
            },
            {
                code: 'it',
                name: 'Italian',
                native: 'Italiano'
            },
            {
                code: 'ja',
                name: 'Japanese',
                native: '日本語'
            },
            {
                code: 'jw',
                name: 'Javanese',
                native: 'Basa Jawa'
            },
            {
                code: 'kn',
                name: 'Kannada',
                native: 'ಕನ್ನಡ'
            },
            {
                code: 'kk',
                name: 'Kazakh',
                native: 'Қазақ'
            },
            {
                code: 'km',
                name: 'Khmer',
                native: 'ខ្មែរ'
            },
            {
                code: 'rw',
                name: 'Kinyarwanda',
                native: 'Ikinyarwanda'
            },
            {
                code: 'kok',
                name: 'Konkani',
                native: 'कोंकणी'
            },
            {
                code: 'ko',
                name: 'Korean',
                native: '한국어'
            },
            {
                code: 'kri',
                name: 'Krio',
                native: 'Krio'
            },
            {
                code: 'ku',
                name: 'Kurdish (Kurmanji)',
                native: 'Kurdî (Kurmanji)'
            },
            {
                code: 'ckb',
                name: 'Kurdish (Sorani)',
                native: 'Kurdî (Sorani)'
            },
            {
                code: 'ky',
                name: 'Kyrgyz',
                native: 'Кыргызча'
            },
            {
                code: 'lo',
                name: 'Lao',
                native: 'ລາວ'
            },
            {
                code: 'la',
                name: 'Latin',
                native: 'Latina'
            },
            {
                code: 'lv',
                name: 'Latvian',
                native: 'Latviešu'
            },
            {
                code: 'ln',
                name: 'Lingala',
                native: 'Lingala'
            },
            {
                code: 'lt',
                name: 'Lithuanian',
                native: 'Lietuvių'
            },
            {
                code: 'lg',
                name: 'Luganda',
                native: 'Luganda'
            },
            {
                code: 'lb',
                name: 'Luxembourgish',
                native: 'Lëtzebuergesch'
            },
            {
                code: 'mk',
                name: 'Macedonian',
                native: 'Македонски'
            },
            {
                code: 'mai',
                name: 'Maithili',
                native: 'मैथिली'
            },
            {
                code: 'mg',
                name: 'Malagasy',
                native: 'Malagasy'
            },
            {
                code: 'ms',
                name: 'Malay',
                native: 'Bahasa Melayu'
            },
            {
                code: 'ml',
                name: 'Malayalam',
                native: 'മലയാളം'
            },
            {
                code: 'mt',
                name: 'Maltese',
                native: 'Malti'
            },
            {
                code: 'mi',
                name: 'Maori',
                native: 'Māori'
            },
            {
                code: 'mr',
                name: 'Marathi',
                native: 'मराठी'
            },
            {
                code: 'mni-Mtei',
                name: 'Meiteilon',
                native: 'ꯃꯤꯇꯩ ꯂꯣꯟ'
            },
            {
                code: 'lus',
                name: 'Mizo',
                native: 'Mizo'
            },
            {
                code: 'mn',
                name: 'Mongolian',
                native: 'Монгол'
            },
            {
                code: 'my',
                name: 'Myanmar',
                native: 'မြန်မာ'
            },
            {
                code: 'ne',
                name: 'Nepali',
                native: 'नेपाली'
            },
            {
                code: 'no',
                name: 'Norwegian',
                native: 'Norsk'
            },
            {
                code: 'or',
                name: 'Odia',
                native: 'ଓଡ଼ିଆ'
            },
            {
                code: 'om',
                name: 'Oromo',
                native: 'Oromo'
            },
            {
                code: 'ps',
                name: 'Pashto',
                native: 'پښتو'
            },
            {
                code: 'fa',
                name: 'Persian',
                native: 'فارسی'
            },
            {
                code: 'pl',
                name: 'Polish',
                native: 'Polski'
            },
            {
                code: 'pt-PT',
                name: 'Portuguese (Portugal)',
                native: 'Português (Portugal)'
            },
            {
                code: 'pt-BR',
                name: 'Portuguese (Brazil)',
                native: 'Português (Brasil)'
            },
            {
                code: 'pa',
                name: 'Punjabi',
                native: 'ਪੰਜਾਬੀ'
            },
            {
                code: 'qu',
                name: 'Quechua',
                native: 'Quechua'
            },
            {
                code: 'ro',
                name: 'Romanian',
                native: 'Română'
            },
            {
                code: 'ru',
                name: 'Russian',
                native: 'Русский'
            },
            {
                code: 'sm',
                name: 'Samoan',
                native: 'Gagana Samoa'
            },
            {
                code: 'sa',
                name: 'Sanskrit',
                native: 'संस्कृत'
            },
            {
                code: 'gd',
                name: 'Scots Gaelic',
                native: 'Gàidhlig'
            },
            {
                code: 'nso',
                name: 'Sepedi',
                native: 'Sesotho sa Leboa'
            },
            {
                code: 'sr',
                name: 'Serbian',
                native: 'Српски'
            },
            {
                code: 'st',
                name: 'Sesotho',
                native: 'Sesotho'
            },
            {
                code: 'sn',
                name: 'Shona',
                native: 'chiShona'
            },
            {
                code: 'sd',
                name: 'Sindhi',
                native: 'سنڌي'
            },
            {
                code: 'sk',
                name: 'Slovak',
                native: 'Slovenčina'
            },
            {
                code: 'sl',
                name: 'Slovenian',
                native: 'Slovenščina'
            },
            {
                code: 'so',
                name: 'Somali',
                native: 'Soomaali'
            },
            {
                code: 'es',
                name: 'Spanish',
                native: 'Español'
            },
            {
                code: 'su',
                name: 'Sundanese',
                native: 'Basa Sunda'
            },
            {
                code: 'sw',
                name: 'Swahili',
                native: 'Kiswahili'
            },
            {
                code: 'sv',
                name: 'Swedish',
                native: 'Svenska'
            },
            {
                code: 'tg',
                name: 'Tajik',
                native: 'Тоҷикӣ'
            },
            {
                code: 'tt',
                name: 'Tatar',
                native: 'Татар'
            },
            {
                code: 'te',
                name: 'Telugu',
                native: 'తెలుగు'
            },
            {
                code: 'th',
                name: 'Thai',
                native: 'ไทย'
            },
            {
                code: 'ti',
                name: 'Tigrinya',
                native: 'ትግርኛ'
            },
            {
                code: 'ts',
                name: 'Tsonga',
                native: 'Xitsonga'
            },
            {
                code: 'tr',
                name: 'Turkish',
                native: 'Türkçe'
            },
            {
                code: 'tk',
                name: 'Turkmen',
                native: 'Türkmen'
            },
            {
                code: 'tw',
                name: 'Twi',
                native: 'Twi'
            },
            {
                code: 'uk',
                name: 'Ukrainian',
                native: 'Українська'
            },
            {
                code: 'ur',
                name: 'Urdu',
                native: 'اردو'
            },
            {
                code: 'ug',
                name: 'Uyghur',
                native: 'ئۇيغۇرچە'
            },
            {
                code: 'uz',
                name: 'Uzbek',
                native: 'O‘zbek'
            },
            {
                code: 'vi',
                name: 'Vietnamese',
                native: 'Tiếng Việt'
            },
            {
                code: 'cy',
                name: 'Welsh',
                native: 'Cymraeg'
            },
            {
                code: 'xh',
                name: 'Xhosa',
                native: 'isiXhosa'
            },
            {
                code: 'yi',
                name: 'Yiddish',
                native: 'ייִדיש'
            },
            {
                code: 'yo',
                name: 'Yoruba',
                native: 'Yorùbá'
            },
            {
                code: 'zu',
                name: 'Zulu',
                native: 'isiZulu'
            }
        ];

        document.addEventListener("DOMContentLoaded", () => {
            const languageGrid = document.getElementById('languageGrid');
            const searchInput = document.getElementById('languageSearch');
            const selectedCount = document.getElementById('selectedCount');
            const clearBtn = document.getElementById('clearSelection');
            const saveBtn = document.getElementById('saveSelection');
            const selectAllBtn = document.getElementById('selectAll');

            let selectedLanguages = [];

            // Render language cards
            function renderLanguages(langList = languages) {
                languageGrid.innerHTML = '';

                langList.forEach(lang => {
                    const isSelected = selectedLanguages.includes(lang.code);

                    const card = document.createElement('div');
                    card.className = `language-card ${isSelected ? 'selected' : ''}`;
                    card.dataset.code = lang.code;

                    card.innerHTML = `
                <div class="language-card-inner">
                    <div class="language-checkbox">
                        <input type="checkbox" id="lang-${lang.code}" ${isSelected ? 'checked' : ''}>
                        <label for="lang-${lang.code}"></label>
                    </div>
                    <div class="language-info">
                        <div class="language-name">${lang.name}</div>
                        <div class="language-native">${lang.native}</div>
                    </div>
                </div>
            `;

                    languageGrid.appendChild(card);

                    // Add event listener
                    card.addEventListener('click', (e) => {
                        if (!e.target.matches('input')) {
                            const checkbox = card.querySelector('input');
                            checkbox.checked = !checkbox.checked;
                            updateSelection(checkbox.checked, lang.code);
                        }
                    });

                    const checkbox = card.querySelector('input');
                    checkbox.addEventListener('change', () => {
                        updateSelection(checkbox.checked, lang.code);
                        card.classList.toggle('selected', checkbox.checked);
                    });
                });

                updateSelectedCount();
            }

            // Update selection
            function updateSelection(isSelected, code) {
                if (isSelected) {
                    // Deselect all others first (single selection mode)
                    selectedLanguages = [code];
                    document.querySelectorAll('.language-card').forEach(card => {
                        if (card.dataset.code !== code) {
                            card.classList.remove('selected');
                            card.querySelector('input').checked = false;
                        }
                    });
                } else {
                    selectedLanguages = selectedLanguages.filter(lang => lang !== code);
                }

                updateSelectedCount();

                // Change Google Translate language
                const select = document.querySelector("#google_translate_element select");
                if (select && isSelected) {
                    select.value = code;
                    select.dispatchEvent(new Event("change"));
                }
            }

            // Update selected count
            function updateSelectedCount() {
                selectedCount.textContent = `${selectedLanguages.length} selected`;
            }

            // Search functionality
            searchInput.addEventListener('input', () => {
                const searchTerm = searchInput.value.toLowerCase();
                const filteredLanguages = languages.filter(lang =>
                    lang.name.toLowerCase().includes(searchTerm) ||
                    lang.native.toLowerCase().includes(searchTerm)
                );
                renderLanguages(filteredLanguages);
            });

            // Clear selection
            clearBtn.addEventListener('click', () => {
                selectedLanguages = [];
                renderLanguages();
            });

            // Select all
            selectAllBtn.addEventListener('click', () => {
                // In single selection mode, this would select the first language
                if (languages.length > 0) {
                    selectedLanguages = [languages[0].code];
                    renderLanguages();

                    // Change Google Translate language
                    const select = document.querySelector("#google_translate_element select");
                    if (select) {
                        select.value = languages[0].code;
                        select.dispatchEvent(new Event("change"));
                    }
                }
            });

            // Save selection
            saveBtn.addEventListener('click', () => {
                // Here you would typically send the selectedLanguages array to your server
                alert(`Selected language: ${selectedLanguages[0] || 'None'}`);
            });

            // Initial render
            renderLanguages();
        });
    </script>

    <style>
        /* Phoenix Language Container */
        .phoenix-language-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        /* Language Controls */
        .language-controls {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .search-box {
            position: relative;
            display: flex;
            align-items: center;
        }

        .search-icon {
            position: absolute;
            left: 12px;
            color: #64748b;
        }

        #languageSearch {
            padding: 10px 12px 10px 40px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            width: 280px;
            transition: all 0.2s;
            {{--  background: #fff;  --}}
        }

        #languageSearch:focus {
            outline: none;
            border-color: #4f46e5;
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }

        .selection-info {
            display: flex;
            align-items: center;
            gap: 12px;
            color: #64748b;
            font-size: 14px;
        }

        .clear-btn {
            background: none;
            border: none;
            color: #ef4444;
            cursor: pointer;
            font-size: 14px;
            padding: 6px 12px;
            border-radius: 6px;
            transition: background 0.2s;
        }

        .clear-btn:hover {
            {{--  background: #fef2f2;  --}}
        }

        /* Language Grid */
        .phoenix-language-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .language-card {
            {{--  background: #fff;  --}} border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 1rem;
            cursor: pointer;
            transition: all 0.2s;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }

        .language-card:hover {
            border-color: #c7d2fe;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .language-card.selected {
            border-color: #4f46e5;
            background: #f5f7ff;
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }

        .language-card-inner {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .language-checkbox {
            position: relative;
        }

        .language-checkbox input[type="checkbox"] {
            position: absolute;
            opacity: 0;
            width: 0;
            height: 0;
        }

        .language-checkbox label {
            display: block;
            width: 20px;
            height: 20px;
            border: 2px solid #cbd5e1;
            border-radius: 6px;
            position: relative;
            cursor: pointer;
            transition: all 0.2s;
        }

        .language-checkbox input[type="checkbox"]:checked+label {
            background: #4f46e5;
            border-color: #4f46e5;
        }

        .language-checkbox input[type="checkbox"]:checked+label:after {
            content: '';
            position: absolute;
            left: 6px;
            top: 2px;
            width: 5px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
        }

        .language-info {
            flex: 1;
        }

        .language-name {
            font-weight: 500;
            color: #64748b;
            margin-bottom: 4px;
        }

        .language-native {
            font-size: 14px;
            color: #64748b;
        }

        /* Action Buttons */
        .language-actions {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
        }

        .phoenix-btn {
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 500;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.2s;
            border: none;
        }

        .phoenix-btn-primary {
            background: #4f46e5;
            color: white;
        }

        .phoenix-btn-primary:hover {
            background: #4338ca;
        }

        .phoenix-btn-secondary {
            background: #f1f5f9;
            color: #475569;
        }

        .phoenix-btn-secondary:hover {
            background: #e2e8f0;
        }




        /* Responsive adjustments */
        @media (max-width: 768px) {
            .phoenix-language-container {
                padding: 1rem;
            }

            .language-controls {
                flex-direction: column;
                align-items: stretch;
            }

            #languageSearch {
                width: 100%;
            }

            .phoenix-language-grid {
                grid-template-columns: 1fr;
            }

            .language-actions {
                flex-direction: column;
            }
        }
    </style>
@endsection
