@extends('layouts.front')
@section('content')
@section('title', $package->title ?? 'Package')


<div class="container-fluid bg-breadcrumb"
    style="background: url({{ asset('img/about_bg.jpg') }}) no-repeat center center;
            background-size: cover;
            background-attachment: fixed;">
    <div class="container text-center py-5" style="max-width: 900px;">


        <h3 class="text-white display-4 fw-bold mb-4 animate__animated animate__fadeInDown">{{ $package->title }}</h3>
        <ol class="breadcrumb justify-content-center mb-0 animate__animated animate__fadeInUp">
            <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-white">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('packages') }}" class="text-white">Packages</a></li>
            <li class="breadcrumb-item active text-primary">{{ $package->title }}</li>
        </ol>
    </div>
</div>

<!-- Main Content -->
<div class="container py-5">
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row g-5">
        <!-- Image Gallery and Tabs -->
        <div class="col-lg-8">
            <!-- Image Gallery -->
            {{--  <div class="row g-3 mb-4">
                @php
                    $images = $package->images ?? collect();
                    $slots = $images->take(4)->values();
                    $missing = 4 - $slots->count();
                @endphp

                <div class="col-md-8">
                    <div class="position-relative rounded-3 overflow-hidden shadow-sm">
                        <img src="{{ $slots->isNotEmpty() ? asset($slots[0]->image_path) : asset('img/packages-1.jpg') }}"
                            class="w-100 object-fit-cover gallery-image" style="height: 400px; cursor: pointer;"
                            alt="{{ $package->title }}" data-bs-toggle="modal" data-bs-target="#imageModal"
                            data-image="{{ $slots->isNotEmpty() ? asset($slots[0]->image_path) : asset('img/packages-1.jpg') }}"
                            data-caption="{{ $package->title }}">
                        <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                            <i class="fas fa-search-plus"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex flex-column gap-3">
                        @foreach ($slots->slice(1) as $index => $img)
                            <div class="position-relative rounded-3 overflow-hidden shadow-sm">
                                <img src="{{ asset($img->image_path) }}" class="w-100 object-fit-cover gallery-image"
                                    style="height: 123px; cursor: pointer;" alt="{{ $package->title }}"
                                    data-bs-toggle="modal" data-bs-target="#imageModal"
                                    data-image="{{ asset($img->image_path) }}" data-caption="{{ $package->title }}">
                                <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                            </div>
                        @endforeach
                        @for ($i = 0; $i < $missing; $i++)
                            <div class="position-relative rounded-3 overflow-hidden shadow-sm">
                                <img src="{{ asset('img/packages-1.jpg') }}"
                                    class="w-100 object-fit-cover gallery-image" style="height: 123px; cursor: pointer;"
                                    alt="{{ $package->title }}" data-bs-toggle="modal" data-bs-target="#imageModal"
                                    data-image="{{ asset('img/packages-1.jpg') }}"
                                    data-caption="{{ $package->title }}">
                                <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                            </div>
                        @endfor
                    </div>
                </div>
            </div>  --}}

            <div class="row g-3 mb-4">
                @php
                    $images = $package->images ?? collect();
                    $slots = $images->take(4)->values();
                    $missing = 4 - $slots->count();
                @endphp

                <div class="col-md-8">
                    <div class="position-relative rounded-3 overflow-hidden shadow-sm" style="height: 400px;">
                        <img src="{{ $slots->isNotEmpty() ? asset($slots[0]->image_path) : asset('img/packages-1.jpg') }}"
                            class="w-100 h-100 gallery-image" style="object-fit: cover; cursor: pointer;"
                            alt="{{ $package->title }}" data-bs-toggle="modal" data-bs-target="#imageModal"
                            data-image="{{ $slots->isNotEmpty() ? asset($slots[0]->image_path) : asset('img/packages-1.jpg') }}"
                            data-caption="{{ $package->title }}">
                        <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                            <i class="fas fa-search-plus"></i>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="d-flex flex-column gap-3">
                        @foreach ($slots->slice(1) as $img)
                            <div class="position-relative rounded-3 overflow-hidden shadow-sm" style="height: 123px;">
                                <img src="{{ asset($img->image_path) }}" class="w-100 h-100 gallery-image"
                                    style="object-fit: cover; cursor: pointer;" alt="{{ $package->title }}"
                                    data-bs-toggle="modal" data-bs-target="#imageModal"
                                    data-image="{{ asset($img->image_path) }}" data-caption="{{ $package->title }}">
                                <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                            </div>
                        @endforeach

                        @for ($i = 0; $i < $missing; $i++)
                            <div class="position-relative rounded-3 overflow-hidden shadow-sm" style="height: 123px;">
                                <img src="{{ asset('img/packages-1.jpg') }}" class="w-100 h-100 gallery-image"
                                    style="object-fit: cover; cursor: pointer;" alt="{{ $package->title }}"
                                    data-bs-toggle="modal" data-bs-target="#imageModal"
                                    data-image="{{ asset('img/packages-1.jpg') }}"
                                    data-caption="{{ $package->title }}">
                                <div class="position-absolute top-0 end-0 p-3 bg-dark bg-opacity-50 text-white">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                            </div>
                        @endfor
                    </div>
                </div>
            </div>

            <!-- Tabs Section -->
            <div class="card border-0 shadow-sm rounded-3 mb-4">
                <div class="card-header bg-light py-3 border-0 rounded-top-3">
                    <ul class="nav nav-tabs" id="packageTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="itineraries-tab" data-bs-toggle="tab"
                                data-bs-target="#itineraries" type="button" role="tab" aria-controls="itineraries"
                                aria-selected="true">Itineraries</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews"
                                type="button" role="tab" aria-controls="reviews"
                                aria-selected="false">Reviews</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="inclusions-tab" data-bs-toggle="tab"
                                data-bs-target="#inclusions" type="button" role="tab" aria-controls="inclusions"
                                aria-selected="false">Inclusions</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="exclusions-tab" data-bs-toggle="tab"
                                data-bs-target="#exclusions" type="button" role="tab"
                                aria-controls="exclusions" aria-selected="false">Exclusions</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="activities-tab" data-bs-toggle="tab"
                                data-bs-target="#activities" type="button" role="tab"
                                aria-controls="activities" aria-selected="false">Activities</button>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="packageTabsContent">
                        <!-- Itineraries Tab -->

                        <div class="tab-pane fade show active" id="itineraries" role="tabpanel"
                            aria-labelledby="itineraries-tab">
                            @if ($itineraries->isEmpty())
                                <div class="text-center py-5">
                                    <div class="empty-state-icon mb-4">
                                        <i class="fas fa-map-marked-alt fa-4x text-primary opacity-50"></i>
                                    </div>
                                    <h5 class="text-muted mb-2">No Itineraries Available</h5>
                                    <p class="text-muted small mb-0">Itineraries for this package will be displayed
                                        here once added.</p>
                                </div>
                            @else
                                <div class="timeline-modern">
                                    @foreach ($itineraries as $itinerary)
                                        <div class="timeline-item mb-4 position-relative">
                                            <!-- Enhanced Timeline Marker -->
                                            <div
                                                class="timeline-marker bg-gradient-primary rounded-circle d-flex align-items-center justify-content-center shadow-sm">
                                                <div class="text-center text-white">
                                                    <i class="fas fa-calendar-day fa-sm mb-1"></i>
                                                    <div class="fw-bold small">Day {{ $itinerary->day_number }}</div>
                                                </div>
                                            </div>

                                            <!-- Timeline Content -->
                                            <div class="timeline-content card border-0 shadow-sm hover-shadow">
                                                <!-- Card Header with Icon -->
                                                <div class="card-header bg-white border-0 py-3">
                                                    <div class="d-flex align-items-center">
                                                        <div class="me-3">
                                                            <i class="fas fa-route text-primary fa-lg"></i>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <h4 class="mb-0 fw-bold text-dark">{{ $itinerary->title }}
                                                            </h4>
                                                            <small class="text-muted">
                                                                <i class="fas fa-clock me-1"></i>
                                                                Day {{ $itinerary->day_number }} Activities
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card-body">
                                                    <!-- Enhanced Images Grid -->


                                                    @if ($itinerary->images->isNotEmpty())
                                                        <div class="row g-3 mb-4">
                                                            <div class="d-flex align-items-center mb-3">
                                                                <i class="fas fa-images text-primary me-2"></i>
                                                                <h6 class="mb-0 fw-semibold">Gallery</h6>
                                                                <span
                                                                    class="badge bg-light text-dark ms-2">{{ $itinerary->images->count() }}
                                                                    photos</span>
                                                            </div>
                                                            @foreach ($itinerary->images as $image)
                                                                <div class="col-md-4 col-6">
                                                                    <div
                                                                        class="position-relative rounded-2 overflow-hidden">
                                                                        <img src="{{ Storage::url($image->image_path) }}"
                                                                            class="img-fluid rounded-2 itinerary-image"
                                                                            style="height: 120px; width: 100%; object-fit: cover; cursor: pointer;"
                                                                            alt="{{ $image->caption ?? 'Itinerary Image' }}"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-target="#imageModal"
                                                                            data-image="{{ Storage::url($image->image_path) }}"
                                                                            data-caption="{{ $image->caption ?? 'Itinerary Image' }}">
                                                                        @if ($image->caption)
                                                                            <div
                                                                                class="position-absolute bottom-0 start-0 end-0 bg-gradient-dark text-white p-3">
                                                                                <div class="d-flex align-items-center">
                                                                                    <i class="fas fa-camera me-2"></i>
                                                                                    <span>{{ $image->caption }}</span>
                                                                                </div>
                                                                            </div>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    @endif

                                                    @php
                                                        $subItineraries = \App\Models\Itinerary::where(
                                                            'package_itinerary_id',
                                                            $itinerary->id,
                                                        )
                                                            ->ordered()
                                                            ->get();
                                                    @endphp

                                                    <!-- Enhanced Daily Plan -->
                                                    @if ($subItineraries->isNotEmpty())
                                                        <div class="daily-plan">
                                                            <div class="d-flex align-items-center mb-3">
                                                                <i class="fas fa-list-check text-primary me-2"></i>
                                                                <h6 class="mb-0 fw-semibold">Daily Activities</h6>
                                                                <span
                                                                    class="badge bg-primary-soft text-primary ms-2">{{ $subItineraries->count() }}
                                                                    activities</span>
                                                            </div>

                                                            <div class="activities-list">
                                                                @foreach ($subItineraries as $index => $subItinerary)
                                                                    <div
                                                                        class="activity-item d-flex align-items-start mb-3 p-3 bg-light rounded-3 border-start border-primary border-4">
                                                                        <div class="activity-number me-3">
                                                                            <span
                                                                                class="badge bg-primary rounded-circle d-flex align-items-center justify-content-center"
                                                                                style="width: 32px; height: 32px;">
                                                                                {{ $subItinerary->order }}
                                                                            </span>
                                                                        </div>
                                                                        <div class="activity-content flex-grow-1">
                                                                            <div class="activity-text">
                                                                                {{ $subItinerary->detail }}</div>
                                                                        </div>
                                                                        <div class="activity-icon ms-2">
                                                                            @if (str_contains(strtolower($subItinerary->detail), 'breakfast') ||
                                                                                    str_contains(strtolower($subItinerary->detail), 'lunch') ||
                                                                                    str_contains(strtolower($subItinerary->detail), 'dinner'))
                                                                                <i
                                                                                    class="fas fa-utensils text-success"></i>
                                                                            @elseif(str_contains(strtolower($subItinerary->detail), 'hotel') ||
                                                                                    str_contains(strtolower($subItinerary->detail), 'accommodation'))
                                                                                <i class="fas fa-bed text-info"></i>
                                                                            @elseif(str_contains(strtolower($subItinerary->detail), 'transport') ||
                                                                                    str_contains(strtolower($subItinerary->detail), 'travel'))
                                                                                <i class="fas fa-car text-warning"></i>
                                                                            @elseif(str_contains(strtolower($subItinerary->detail), 'visit') || str_contains(strtolower($subItinerary->detail), 'tour'))
                                                                                <i
                                                                                    class="fas fa-map-marker-alt text-danger"></i>
                                                                            @else
                                                                                <i class="fas fa-clock text-muted"></i>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <!-- Enhanced Tour Route Map -->
                                <div class="card border-0 shadow-lg mt-5">
                                    <div class="card-header bg-gradient-primary text-white py-3 border-0">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-map-marked-alt fa-lg me-3"></i>
                                            <div>
                                                <h4 class="mb-0 fw-bold">Interactive Tour Route</h4>
                                                <small class="opacity-75">Explore your journey on the map</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body p-0 position-relative">
                                        <div id="tour-map" style="height: 450px; border-radius: 0 0 12px 12px;">
                                        </div>

                                        <!-- Map Controls -->
                                        <div class="position-absolute top-0 end-0 m-3 z-3">
                                            <div class="btn-group-vertical shadow-sm">
                                                <button class="btn btn-light btn-sm" onclick="zoomIn()"
                                                    title="Zoom In">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                                <button class="btn btn-light btn-sm" onclick="zoomOut()"
                                                    title="Zoom Out">
                                                    <i class="fas fa-minus"></i>
                                                </button>
                                                <button class="btn btn-light btn-sm" onclick="resetView()"
                                                    title="Reset View">
                                                    <i class="fas fa-home"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>

                        <!-- Custom Styles -->
                        <style>
                            .bg-gradient-primary {
                                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                            }

                            .bg-gradient-dark {
                                background: linear-gradient(to top, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0.4) 70%, transparent 100%);
                            }

                            .bg-primary-soft {
                                background-color: rgba(102, 126, 234, 0.1);
                            }

                            .timeline-marker {
                                width: 80px;
                                height: 80px;
                                margin-left: -40px;
                                border: 4px solid #fff;
                                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                            }

                            .hover-shadow {
                                transition: all 0.3s ease;
                            }

                            .hover-shadow:hover {
                                transform: translateY(-2px);
                                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15) !important;
                            }

                            .hover-zoom:hover {
                                transform: scale(1.05);
                            }

                            .hover-overlay {
                                transition: opacity 0.3s ease;
                            }

                            .itinerary-image:hover+.hover-overlay,
                            .itinerary-image:hover~.hover-overlay {
                                opacity: 1 !important;
                            }

                            .activity-item {
                                transition: all 0.3s ease;
                                border-left-width: 4px !important;
                            }

                            .activity-item:hover {
                                transform: translateX(5px);
                                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                            }

                            .empty-state-icon {
                                animation: float 3s ease-in-out infinite;
                            }

                            @keyframes float {
                                0% {
                                    transform: translateY(0px);
                                }

                                50% {
                                    transform: translateY(-10px);
                                }

                                100% {
                                    transform: translateY(0px);
                                }
                            }

                            .z-3 {
                                z-index: 3;
                            }

                            @media (max-width: 768px) {
                                .timeline-marker {
                                    width: 60px;
                                    height: 60px;
                                    margin-left: -30px;
                                }

                                .timeline-marker .small {
                                    font-size: 0.7rem;
                                }

                                .activity-item {
                                    padding: 0.75rem !important;
                                }
                            }
                        </style>



                        <!-- Reviews Tab -->
                        <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                            <h5 class="fw-bold mb-3">Add Your Review</h5>
                            @if (session('success'))
                                <div class="alert alert-success mb-3">{{ session('success') }}</div>
                            @endif

                            <form action="{{ route('reviews.store') }}" method="POST" class="row g-3">
                                @csrf
                                <input type="hidden" name="package_id" value="{{ $package->id }}">

                                <div class="col-md-6">
                                    <label for="user_name" class="form-label fw-semibold">Your Name</label>
                                    <input id="user_name" name="user_name" required class="form-control"
                                        placeholder="Enter your name">
                                </div>

                                <div class="col-md-6">
                                    <label for="ratings" class="form-label fw-semibold">Rating</label>
                                    <select id="ratings" name="ratings" class="form-select" required>
                                        <option value="5">5 - Excellent</option>
                                        <option value="4">4 - Very Good</option>
                                        <option value="3">3 - Good</option>
                                        <option value="2">2 - Fair</option>
                                        <option value="1">1 - Poor</option>
                                    </select>
                                </div>

                                <div class="col-12">
                                    <label for="comments" class="form-label fw-semibold">Comments</label>
                                    <textarea id="comments" name="comments" class="form-control" rows="3"
                                        placeholder="Share your experience..."></textarea>
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary px-4">Submit Review</button>
                                </div>
                            </form>
                            <hr class="my-4">
                            @php
                                $approvedReviews = $package->reviews()->where('status', 'approved')->latest()->get();
                            @endphp

                            @if ($approvedReviews->isEmpty())
                                <div class="text-center py-4">
                                    <i class="fas fa-comments fa-2x text-muted mb-3"></i>
                                    <p class="text-muted mb-0">No reviews yet. Be the first to review this package.</p>
                                </div>
                            @else
                                <div class="row g-3">
                                    @foreach ($approvedReviews as $review)
                                        <div class="col-12">
                                            <div class="border rounded-2 p-3">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <strong class="text-dark">{{ $review->user_name }}</strong>
                                                    <div class="text-warning">
                                                        @for ($i = 1; $i <= 5; $i++)
                                                            <i
                                                                class="fas fa-star{{ $i <= $review->ratings ? '' : '-empty' }}"></i>
                                                        @endfor
                                                    </div>
                                                </div>
                                                <small class="text-muted d-block mb-2">
                                                    <i class="far fa-clock me-1"></i>
                                                    {{ $review->created_at ? $review->created_at->format('M d, Y') : '' }}
                                                </small>
                                                <p class="mb-0 text-dark">{{ $review->comments }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif


                        </div>

                        <!-- Inclusions Tab -->
                        <div class="tab-pane fade" id="inclusions" role="tabpanel" aria-labelledby="inclusions-tab">
                            @php
                                $inclusionsList = [];
                                if (!empty($package->inclution) && !empty($package->inclution->inclution)) {
                                    $inclusionsList = json_decode($package->inclution->inclution, true) ?: [];
                                } elseif (isset($package->inclutions) && $package->inclutions->count()) {
                                    $inclusionsList = $package->inclutions
                                        ->pluck('inclution')
                                        ->filter()
                                        ->flatten()
                                        ->toArray();
                                }
                            @endphp
                            @if (count($inclusionsList))
                                <div class="list-group list-group-flush">
                                    @foreach ($inclusionsList as $inc)
                                        <div class="list-group-item border-0 px-0 py-2">
                                            <i class="fas fa-check text-success me-2"></i>
                                            <small>{{ is_array($inc) ? $inc['text'] ?? implode(' ', (array) $inc) : $inc }}</small>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-muted small mb-0"><i class="fas fa-info-circle me-1"></i>No inclusions
                                    listed.</p>
                            @endif
                        </div>

                        <!-- Exclusions Tab -->
                        <div class="tab-pane fade" id="exclusions" role="tabpanel" aria-labelledby="exclusions-tab">
                            @php
                                $exclusionsList = [];
                                if (!empty($package->exclution) && !empty($package->exclution->exclution)) {
                                    $exclusionsList = json_decode($package->exclution->exclution, true) ?: [];
                                } elseif (isset($package->exclutions) && $package->exclutions->count()) {
                                    $exclusionsList = $package->exclutions
                                        ->pluck('exclution')
                                        ->filter()
                                        ->flatten()
                                        ->toArray();
                                }
                            @endphp
                            @if (count($exclusionsList))
                                <div class="list-group list-group-flush">
                                    @foreach ($exclusionsList as $exc)
                                        <div class="list-group-item border-0 px-0 py-2">
                                            <i class="fas fa-times text-danger me-2"></i>
                                            <small>{{ is_array($exc) ? $exc['text'] ?? implode(' ', (array) $exc) : $exc }}</small>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-muted small mb-0"><i class="fas fa-info-circle me-1"></i>No exclusions
                                    listed.</p>
                            @endif
                        </div>

                        {{--  <!-- Activities Tab -->
                        <div class="tab-pane fade" id="activities" role="tabpanel" aria-labelledby="activities-tab">
                            @if (isset($itineraries) && $itineraries->isNotEmpty())
                                @foreach ($itineraries as $itinerary)
                                    @if (isset($itinerary->activities) && $itinerary->activities->isNotEmpty())
                                        <div class="mb-4">
                                            <h5 class="fw-semibold mb-3">Day {{ $itinerary->day_number }}:
                                                {{ $itinerary->title }}</h5>
                                            <div class="row g-3">
                                                @foreach ($itinerary->activities as $activity)
                                                    <div class="col-12">
                                                        <div class="d-flex align-items-start border rounded-2 p-3">
                                                            @if ($activity->image_path)
                                                                <div class="flex-shrink-0 me-3">
                                                                    <img src="{{ asset($activity->image_path) }}"
                                                                        alt="{{ $activity->name }}"
                                                                        class="rounded-2 activity-image"
                                                                        style="width: 80px; height: 80px; object-fit: cover; cursor: pointer;"
                                                                        data-bs-toggle="modal"
                                                                        data-bs-target="#imageModal"
                                                                        data-image="{{ asset($activity->image_path) }}"
                                                                        data-caption="{{ $activity->name }}">
                                                                </div>
                                                            @endif
                                                            <div class="flex-grow-1">
                                                                <h6 class="fw-bold mb-1">{{ $activity->name }}</h6>
                                                                <p class="text-muted small mb-2">
                                                                    {{ Str::limit($activity->description, 120) }}</p>
                                                                <small class="text-muted">
                                                                    <i class="far fa-clock me-1"></i>
                                                                    Added:
                                                                    {{ $activity->created_at ? $activity->created_at->format('M d, Y') : '' }}
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <div class="text-center py-4">
                                    <i class="fas fa-tasks fa-2x text-muted mb-3"></i>
                                    <p class="text-muted mb-0">No activities found for this package.</p>
                                </div>
                            @endif
                        </div>  --}}
                        <!-- Activities Tab -->
                        <div class="tab-pane fade" id="activities" role="tabpanel" aria-labelledby="activities-tab">
                            @if (isset($itineraries) && $itineraries->isNotEmpty())
                                @foreach ($itineraries as $itinerary)
                                    @if (isset($itinerary->activities) && $itinerary->activities->isNotEmpty())
                                        <div class="mb-4">
                                            <h5 class="fw-semibold mb-3">Day {{ $itinerary->day_number }}:
                                                {{ $itinerary->title }}</h5>
                                            <div class="row g-3">
                                                @foreach ($itinerary->activities as $activity)
                                                    <div class="col-12">
                                                        <div class="d-flex align-items-start border rounded-2 p-3">
                                                            @if ($activity->image_path)
                                                                <div class="flex-shrink-0 me-4">
                                                                    <img src="{{ asset($activity->image_path) }}"
                                                                        alt="{{ $activity->name }}"
                                                                        class="rounded-2 activity-image"
                                                                        style="width: 150px; height: 150px; object-fit: cover; cursor: pointer;"
                                                                        data-bs-toggle="modal"
                                                                        data-bs-target="#imageModal"
                                                                        data-image="{{ asset($activity->image_path) }}"
                                                                        data-caption="{{ $activity->name }}">
                                                                </div>
                                                            @endif
                                                            <div class="flex-grow-1">
                                                                <h6 class="fw-bold mb-2">{{ $activity->name }}</h6>
                                                                <p class="text-muted mb-2">
                                                                    {{ Str::limit($activity->description, 250) }}</p>
                                                                <small class="text-muted">
                                                                    <i class="far fa-clock me-1"></i>
                                                                    Added:
                                                                    {{ $activity->created_at ? $activity->created_at->format('M d, Y') : '' }}
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <div class="text-center py-4">
                                    <i class="fas fa-tasks fa-2x text-muted mb-3"></i>
                                    <p class="text-muted mb-0">No activities found for this package.</p>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar - Package Details -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm rounded-3 sticky-top" style="top: 100px;">
                <div class="card-header bg-primary text-white py-3 rounded-top-3">
                    <h2 class="h4 mb-0 fw-bold">{{ $package->title }}</h2>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-umbrella-beach text-muted me-2"></i>
                        <small class="text-muted">
                            {{ $package->category->name ?? ($package->category->title ?? '') }} /
                            {{ $package->subCategory->name ?? ($package->subCategory->title ?? '') }}
                        </small>
                    </div>

                    {{--  <div class="price-section mb-4">
                        <h3 class="text-primary fw-bold mb-2">
                            {{ $package->price ? '$' . number_format($package->price, 2) : 'Contact for price' }}
                        </h3>
                        <small class="text-muted">Per person</small>
                    </div>  --}}

                    <div class="description-section mb-4">
                        <h5 class="fw-semibold mb-3">Description</h5>
                        <div class="text-muted lh-base">
                            {!! $package->description !!}
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-primary btn-lg fw-semibold py-3" data-book-package
                            data-package-id="{{ $package->id }}" data-package-title="{{ $package->title }}"
                            data-package-price="{{ $package->price }}">
                            <i class="fas fa-calendar-check me-2"></i>Book Now
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 rounded-3">
            <div class="modal-header bg-primary text-white border-0 rounded-top-3">
                <h5 class="modal-title" id="imageModalCaption"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <img id="modalImage" src="" class="img-fluid w-100" alt="Full-size image"
                    style="max-height: 70vh; object-fit: contain;">
            </div>
        </div>
    </div>
</div>

<!-- Booking Modal -->
<div class="modal fade" id="bookingModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 rounded-3 shadow-lg">
            <div class="modal-header bg-primary text-white py-3 rounded-top-3">
                <h5 class="modal-title fw-bold">Inquiry: <span id="bookingPackageTitle"></span></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <form method="POST" action="{{ route('bookings.store') }}">
                @csrf
                <div class="modal-body p-4">
                    {{--  <div class="alert alert-info border-0 mb-4">
                        <h6 class="fw-bold mb-1">Package Price</h6>
                        <span class="h5 text-primary fw-bold" id="bookingPackagePrice"></span>
                    </div>  --}}

                    <input type="hidden" name="package_id" id="booking_package_id">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-semibold">Your Name</label>
                            <input id="name" name="name" required class="form-control"
                                placeholder="Enter your name">
                        </div>

                        <div class="col-md-6">
                            <label for="email" class="form-label fw-semibold">Email</label>
                            <input id="email" name="email" required type="email" class="form-control"
                                placeholder="Enter your email">
                        </div>

                        <div class="col-md-6">
                            <label for="mobile" class="form-label fw-semibold">Mobile</label>
                            <input id="mobile" name="mobile" required type="text" class="form-control"
                                placeholder="Enter your mobile number">
                        </div>

                        <div class="col-md-6">
                            <label for="num_people" class="form-label fw-semibold">Number of People</label>
                            <input id="num_people" name="num_people" type="number" value="1" min="1"
                                required class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label for="expected_date" class="form-label fw-semibold">Expected Date</label>
                            <input id="expected_date" name="expected_date" type="date" required
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label for="country" class="form-label fw-semibold">Country</label>
                            <input id="country" name="country" type="text" required class="form-control"
                                placeholder="Enter your country">
                        </div>

                        <div class="col-12">
                            <label for="notes" class="form-label fw-semibold">Special Requests / Notes</label>
                            <textarea id="notes" name="notes" class="form-control" rows="3" placeholder="Any additional notes"></textarea>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0 bg-light rounded-bottom-3">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary fw-semibold">Confirm Booking</button>
                </div>
            </form>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<link rel="stylesheet" href="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.css" />
<style>
    .gallery-image,
    .itinerary-image,
    .activity-image {
        transition: transform 0.3s ease;
    }

    .gallery-image:hover,
    .itinerary-image:hover,
    .activity-image:hover {
        transform: scale(1.05);
    }

    .timeline-modern {
        position: relative;
        padding-left: 40px;
    }

    .timeline-modern::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 3px;
        background: #007bff;
        border-radius: 3px;
    }

    .timeline-item {
        position: relative;
        margin-bottom: 30px;
    }

    .timeline-marker {
        position: absolute;
        left: -40px;
        top: 20px;
        width: 40px;
        height: 40px;
        z-index: 2;
    }

    .sticky-top {
        position: sticky;
        z-index: 10;
    }

    .card {
        transition: transform 0.2s ease;
    }

    .card:hover {
        transform: translateY(-2px);
    }

    .btn {
        transition: all 0.3s ease;
    }

    .btn:hover {
        transform: translateY(-1px);
    }

    .nav-tabs .nav-link {
        color: #333;
        font-weight: 500;
        border: none;
        border-bottom: 2px solid transparent;
        transition: all 0.3s ease;
    }

    .nav-tabs .nav-link.active {
        color: #007bff;
        border-bottom: 2px solid #007bff;
        background: transparent;
    }

    .nav-tabs .nav-link:hover {
        color: #007bff;
        border-bottom: 2px solid #007bff;
    }

    @media (max-width: 768px) {
        .timeline-modern {
            padding-left: 30px;
        }

        .timeline-modern::before {
            left: 15px;
        }

        .timeline-marker {
            left: -30px;
            width: 30px;
            height: 30px;
        }

        .timeline-marker span {
            font-size: 0.8rem;
        }

        .nav-tabs {
            flex-wrap: nowrap;
            overflow-x: auto;
            white-space: nowrap;
        }

        .nav-tabs .nav-item {
            flex: 0 0 auto;
        }
    }
</style>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.js"></script>
<script>
    @if (!$itineraries->isEmpty())
        var tourMap = L.map('tour-map').setView([6.9041, 79.8977], 8);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(tourMap);

        var startPoint = [6.9041, 79.8977];
        L.marker(startPoint, {
            icon: L.divIcon({
                className: 'custom-div-icon',
                html: '<div style="background-color: #dc3545; width: 30px; height: 30px; border-radius: 50%; border: 3px solid white; display: flex; align-items: center; justify-content: center;"><i class="fas fa-plane text-white" style="font-size: 12px;"></i></div>',
                iconSize: [30, 30],
                iconAnchor: [15, 15]
            })
        }).addTo(tourMap).bindPopup('Bandaranaike International Airport (Start)');

        var waypoints = [L.latLng(startPoint[0], startPoint[1])];
        @foreach ($itineraries as $index => $itinerary)
            var coords{{ $index }} = JSON.parse('{!! $itinerary->map_url !!}');
            waypoints.push(L.latLng(coords{{ $index }}.lat, coords{{ $index }}.lng));
            L.marker([coords{{ $index }}.lat, coords{{ $index }}.lng], {
                icon: L.divIcon({
                    className: 'custom-div-icon',
                    html: '<div style="background-color: #007bff; color: white; width: 32px; height: 32px; border-radius: 50%; border: 3px solid white; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 12px;">{{ $itinerary->day_number }}</div>',
                    iconSize: [32, 32],
                    iconAnchor: [16, 16]
                })
            }).addTo(tourMap).bindPopup(
                '<strong>Day {{ $itinerary->day_number }}:</strong><br>{{ $itinerary->title }}');
        @endforeach

        var routingControl = L.Routing.control({
            waypoints: waypoints,
            routeWhileDragging: false,
            addWaypoints: false,
            createMarker: function() {
                return null;
            },
            lineOptions: {
                styles: [{
                    color: '#007bff',
                    weight: 5,
                    opacity: 0.8
                }]
            },
            router: L.Routing.osrmv1({
                serviceUrl: 'https://router.project-osrm.org/route/v1'
            }),
            show: false,
            fitSelectedRoutes: true
        }).addTo(tourMap);
    @endif

    // Image Modal Handler
    document.addEventListener('DOMContentLoaded', function() {
        var imageModal = document.getElementById('imageModal');
        imageModal.addEventListener('show.bs.modal', function(event) {
            var button = event.relatedTarget;
            var imageSrc = button.getAttribute('data-image');
            var caption = button.getAttribute('data-caption');
            var modalImage = imageModal.querySelector('#modalImage');
            var modalCaption = imageModal.querySelector('#imageModalCaption');
            modalImage.src = imageSrc;
            modalCaption.textContent = caption;
        });

        // Booking modal population
        var bookingButtons = document.querySelectorAll('[data-book-package]');
        bookingButtons.forEach(function(btn) {
            btn.addEventListener('click', function(e) {
                var pkgId = btn.getAttribute('data-package-id');
                var pkgTitle = btn.getAttribute('data-package-title');
                var pkgPrice = btn.getAttribute('data-package-price');
                document.getElementById('bookingPackageTitle').textContent = pkgTitle;
                {{--  document.getElementById('bookingPackagePrice').textContent = pkgPrice ? '$' +
                    parseFloat(pkgPrice).toFixed(2) : 'Contact for price';  --}}
                document.getElementById('booking_package_id').value = pkgId;

                var bookingModalEl = document.getElementById('bookingModal');
                var bookingModal = new bootstrap.Modal(bookingModalEl);
                bookingModal.show();
            });
        });
    });
</script>
@endsection
