{{--  @extends('layouts.front')
@section('content')
@section('title', 'CEYLON THARU TOURS | TOUR PACKAGES')


<!-- Header Start -->
<div class="container-fluid bg-breadcrumb"
    style="background: url({{ asset('img/about_bg.jpg') }}) no-repeat center center;
            background-size: cover;
            background-attachment: fixed;">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">Travel Packages</h1>
            <ol class="breadcrumb justify-content-center mb-0">
                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Pages</a></li>
                <li class="breadcrumb-item active text-white">Packages</li>
            </ol>
    </div>
</div>
<!-- Header End -->

<!-- Packages Start -->
<div class="container-fluid packages py-5">
    <div class="container py-5">
        <div class="mx-auto text-center mb-5" style="max-width: 900px;">
            <h5 class="section-title px-3">Packages</h5>
            <h1 class="mb-0">Awesome Packages</h1>
        </div>
        <div class="row mb-4">
            <div class="col-md-4">
                <form id="filterForm" method="GET" action="{{ route('packages') }}">
                    <div class="input-group mb-2">
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                            placeholder="Search packages...">
                        <button class="btn btn-primary" type="submit">Search</button>
                    </div>
                    <div class="row g-2">
                        <div class="col-6">
                            <select name="category_id" class="form-select"
                                onchange="document.getElementById('filterForm').submit()">
                                <option value="">All Categories</option>
                                @foreach ($categories ?? [] as $cat)
                                    <option value="{{ $cat->id }}"
                                        {{ request('category_id') == $cat->id ? 'selected' : '' }}>
                                        {{ $cat->name ?? ($cat->title ?? 'Category') }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6">
                            <select name="sub_category_id" class="form-select"
                                onchange="document.getElementById('filterForm').submit()">
                                <option value="">All Subcategories</option>
                                @foreach ($subcategories ?? [] as $sub)
                                    <option value="{{ $sub->id }}"
                                        {{ request('sub_category_id') == $sub->id ? 'selected' : '' }}>
                                        {{ $sub->name ?? ($sub->title ?? 'Subcategory') }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="row">
            @forelse($packages ?? [] as $package)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="packages-item h-100 shadow-sm rounded overflow-hidden">
                        <div class="packages-img position-relative">
                            @if ($package->images && $package->images->first())
                                <img src="{{ asset($package->images->first()->image_path) }}"
                                    class="img-fluid w-100 rounded-top" alt="{{ $package->title }}">
                            @else
                                <img src="{{ asset('img/packages-1.jpg') }}" class="img-fluid w-100 rounded-top"
                                    alt="{{ $package->title }}">
                            @endif
                            <div class="packages-info d-flex border border-start-0 border-end-0 position-absolute"
                                style="width: 100%; bottom: 0; left: 0; z-index: 5;">
                                <small class="flex-fill text-center border-end py-2"><i
                                        class="fa fa-map-marker-alt me-2"></i>{{ $package->title }}</small>
                                <small class="flex-fill text-center border-end py-2"><i
                                        class="fa fa-calendar-alt me-2"></i>Duration</small>
                                <small class="flex-fill text-center py-2"><i class="fa fa-user me-2"></i>Person</small>
                            </div>
                            <div class="packages-price py-2 px-4">
                                {{ $package->price ? '$' . number_format($package->price, 2) : '' }}</div>
                        </div>
                        <div class="packages-content bg-light p-4 d-flex flex-column" style="min-height:240px;">
                            <div>
                                <h5 class="mb-0">{{ $package->title }}</h5>
                                <small
                                    class="text-uppercase">{{ $package->category->name ?? ($package->category->title ?? '') }}
                                    / {{ $package->subCategory->name ?? ($package->subCategory->title ?? '') }}</small>
                                <div class="mb-3">
                                    <small class="fa fa-star text-primary"></small>
                                    <small class="fa fa-star text-primary"></small>
                                    <small class="fa fa-star text-primary"></small>
                                    <small class="fa fa-star text-primary"></small>
                                    <small class="fa fa-star text-primary"></small>
                                </div>
                                <p class="mb-4">{{ Str::limit(strip_tags($package->description), 120) }}</p>
                            </div>
                            <div class="mt-auto row bg-primary rounded-bottom mx-0">
                                <div class="col-6 text-start px-0">
                                    <a href="{{ route('packages.show', $package->slug) }}"
                                        class="btn-hover btn text-white py-2 px-4">See more</a>
                                </div>
                                <div class="col-6 text-end px-0">
                                    <a href="#" class="btn-hover btn text-white py-2 px-4">Book Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <p>No packages found.</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
<!-- Packages End -->


@endsection  --}}

@extends('layouts.front')
@section('content')
@section('title', 'CEYLON THARU TOURS | TOUR PACKAGES')

<style>
    /* Enhanced UI Styles */
    .bg-breadcrumb {
        position: relative;
        overflow: hidden;
    }

    .bg-breadcrumb::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1;
    }

    .bg-breadcrumb .container {
        position: relative;
        z-index: 2;
    }

    .search-hero {
        background: rgba(255, 255, 255, 0.95);
        border-radius: 15px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        margin-top: 30px;
        max-width: 800px;
        margin-left: auto;
        margin-right: auto;
    }

    .search-title {
        text-align: center;
        margin-bottom: 20px;
        color: #2c3e50;
        font-weight: 600;
    }

    .filter-form {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        justify-content: center;
        align-items: end;
    }

    .form-group {
        flex: 1;
        min-width: 200px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
        color: #555;
    }

    .search-input-group {
        position: relative;
        display: flex;
    }

    .search-input {
        border-radius: 30px 0 0 30px;
        padding-left: 20px;
        border: 2px solid #e9ecef;
        border-right: none;
        transition: all 0.3s;
    }

    .search-input:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
    }

    .search-btn {
        border-radius: 0 30px 30px 0;
        background: #3498db;
        border: 2px solid #3498db;
        color: white;
        padding: 0 20px;
        transition: all 0.3s;
    }

    .search-btn:hover {
        background: #2980b9;
        border-color: #2980b9;
    }

    .filter-select {
        border-radius: 10px;
        border: 2px solid #e9ecef;
        transition: all 0.3s;
    }

    .filter-select:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
    }

    .packages-item {
        transition: transform 0.3s, box-shadow 0.3s;
        border: none;
        overflow: hidden;
    }

    .packages-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
    }

    .packages-img {
        position: relative;
        overflow: hidden;
    }

    .packages-img img {
        transition: transform 0.5s;
        height: 250px;
        object-fit: cover;
        width: 100%;
    }

    .packages-item:hover .packages-img img {
        transform: scale(1.05);
    }

    .packages-price {
        position: absolute;
        top: 15px;
        right: 0;
        background: #3498db;
        color: white;
        padding: 8px 15px;
        border-radius: 30px 0 0 30px;
        font-weight: 600;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    }

    .packages-info {
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: blur(5px);
        padding: 10px 0;
    }

    .packages-content {
        transition: background 0.3s;
    }

    .packages-item:hover .packages-content {
        background: #f8f9fa;
    }

    .btn-hover {
        transition: all 0.3s;
        font-weight: 500;
        width: 100%;
        border-radius: 0;
    }

    .btn-hover:hover {
        background: rgba(255, 255, 255, 0.2);
        transform: translateY(-2px);
    }

    .no-packages {
        text-align: center;
        padding: 60px 20px;
        color: #7f8c8d;
    }

    .no-packages i {
        font-size: 60px;
        margin-bottom: 20px;
        color: #bdc3c7;
    }

    .rating-stars {
        color: #f39c12;
    }

    @media (max-width: 768px) {
        .filter-form {
            flex-direction: column;
        }

        .form-group {
            min-width: 100%;
        }

        .search-hero {
            padding: 20px;
        }
    }
</style>

<!-- Header Start -->
<div class="container-fluid bg-breadcrumb"
    style="background: url({{ asset('img/about_bg.jpg') }}) no-repeat center center;
            background-size: cover;
            background-attachment: fixed;">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">Travel Packages</h1>
            <ol class="breadcrumb justify-content-center mb-0">
                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Pages</a></li>
                <li class="breadcrumb-item active text-white">Packages</li>
            </ol>


    </div>
</div>
<!-- Header End -->

<!-- Packages Start -->
<div class="container-fluid packages py-5">
    <div class="container py-5">
        <div class="mx-auto text-center mb-5" style="max-width: 900px;">
            <h5 class="section-title px-3">Packages</h5>
            <h1 class="mb-0">Awesome Packages</h1>
            <p class="mb-0">Discover our handpicked selection of unforgettable travel experiences</p>
        </div>
        <!-- Enhanced Search Section -->
        <div class="search-hero">
            <h4 class="search-title">Find Your Perfect Tour Package</h4>
            <form id="filterForm" method="GET" action="{{ route('packages') }}">
                <div class="filter-form">
                    <div class="form-group">
                        <label for="search">Search Packages</label>
                        <div class="search-input-group">
                            <input type="text" name="search" value="{{ request('search') }}"
                                class="form-control search-input" id="search"
                                placeholder="Enter destination, activity, or package name...">
                            <button class="btn search-btn" type="submit">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="category">Category</label>
                        <select name="category_id" id="category" class="form-select filter-select"
                            onchange="document.getElementById('filterForm').submit()">
                            <option value="">All Categories</option>
                            @foreach ($categories ?? [] as $cat)
                                <option value="{{ $cat->id }}"
                                    {{ request('category_id') == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name ?? ($cat->title ?? 'Category') }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="subcategory">Subcategory</label>
                        <select name="sub_category_id" id="subcategory" class="form-select filter-select"
                            onchange="document.getElementById('filterForm').submit()">
                            <option value="">All Subcategories</option>
                            @foreach ($subcategories ?? [] as $sub)
                                <option value="{{ $sub->id }}"
                                    {{ request('sub_category_id') == $sub->id ? 'selected' : '' }}>
                                    {{ $sub->name ?? ($sub->title ?? 'Subcategory') }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </form>
        </div>
        <hr class="my-5">
        <div class="row">
            @forelse($packages ?? [] as $package)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="packages-item h-100 shadow-sm rounded overflow-hidden">
                        <div class="packages-img position-relative">
                            @if ($package->images && $package->images->first())
                                <img src="{{ asset($package->images->first()->image_path) }}"
                                    class="img-fluid w-100 rounded-top" alt="{{ $package->title }}">
                            @else
                                <img src="{{ asset('img/packages-1.jpg') }}" class="img-fluid w-100 rounded-top"
                                    alt="{{ $package->title }}">
                            @endif
                            <div class="packages-info d-flex border border-start-0 border-end-0 position-absolute"
                                style="width: 100%; bottom: 0; left: 0; z-index: 5;">
                                <small class="flex-fill text-center border-end py-2"><i
                                        class="fa fa-map-marker-alt me-2"></i>{{ $package->title }}</small>
                                {{--  <small class="flex-fill text-center border-end py-2"><i
                                        class="fa fa-calendar-alt me-2"></i>3 days</small>
                                <small class="flex-fill text-center py-2"><i class="fa fa-user me-2"></i>10 Person</small>  --}}
                            </div>
                            {{--  <div class="packages-price py-2 px-4">
                                {{ $package->price ? '$' . number_format($package->price, 2) : 'Contact for price' }}
                            </div>  --}}
                        </div>
                        <div class="packages-content bg-light p-4 d-flex flex-column" style="min-height:240px;">
                            <div>
                                <h5 class="mb-0">{{ $package->title }}</h5>
                                <small
                                    class="text-uppercase">{{ $package->category->name ?? ($package->category->title ?? '') }}
                                    / {{ $package->subCategory->name ?? ($package->subCategory->title ?? '') }}</small>
                                {{--  <div class="mb-3 rating-stars">
                                    <small class="fa fa-star"></small>
                                    <small class="fa fa-star"></small>
                                    <small class="fa fa-star"></small>
                                    <small class="fa fa-star"></small>
                                    <small class="fa fa-star"></small>
                                    <span class="ms-1">(24)</span>
                                </div>  --}}
                                <p class="mb-4">{{ Str::limit(strip_tags($package->description), 120) }}</p>
                            </div>
                            <div class="mt-auto row bg-primary rounded-bottom mx-0">
                                {{--  <div class="col-6 text-start px-0">  --}}
                                <a href="{{ route('packages.show', $package->slug) }}"
                                    class="btn-hover btn text-white py-2 px-4">See more</a>
                                {{--  </div>  --}}
                                {{--  <div class="col-6 text-end px-0">
                                    <a href="#" class="btn-hover btn text-white py-2 px-4">Book Now</a>
                                </div>  --}}
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="no-packages">
                        <i class="fa fa-map-signs"></i>
                        <h3>No packages found</h3>
                        <p>Try adjusting your search filters or browse all categories</p>
                        <a href="{{ route('packages') }}" class="btn btn-primary mt-3">View All Packages</a>
                    </div>
                </div>
            @endforelse
        </div>

        <!-- Pagination (if applicable) -->
        {{--  @if (isset($packages) && $packages->hasPages())
            <div class="mt-5 d-flex justify-content-center">
                {{ $packages->links() }}
            </div>
        @endif  --}}
    </div>
</div>
<!-- Packages End -->

<script>
    // Add some interactive functionality
    document.addEventListener('DOMContentLoaded', function() {
        // Add smooth scrolling to the page
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });

        // Add animation to package cards when they come into view
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = 1;
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Apply animation to package cards
        document.querySelectorAll('.packages-item').forEach((card, index) => {
            card.style.opacity = 0;
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.5s, transform 0.5s';
            card.style.transitionDelay = (index * 0.1) + 's';

            observer.observe(card);
        });
    });
</script>

@endsection
