<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>@yield('title', 'CEYLON THARU TOURS')</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    {{--  Google Web Fonts  --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600&family=Roboto&display=swap" rel="stylesheet">

    {{--  Icon Font Stylesheet  --}}
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('img/favicon_icon.png') }}">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    {{--  Libraries Stylesheet  --}}
    <link href="{{ asset('lib/owlcarousel/assets/owl.carousel.min.css') }}" rel="stylesheet">
    <link href="{{ asset('lib/lightbox/css/lightbox.min.css') }}" rel="stylesheet">

    {{--  Customized Bootstrap Stylesheet  --}}
    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">

    {{--  Template Stylesheet  --}}
    <link href="{{ asset('css/style.css') }}" rel="stylesheet">
</head>

<body>

    {{--  Preloader Start  --}}
    <style>
        @keyframes pulse {
            0% {
                transform: scale(1);
                opacity: 0.7;
            }

            50% {
                transform: scale(1.1);
                opacity: 1;
            }

            100% {
                transform: scale(1);
                opacity: 0.7;
            }
        }
    </style>
    <div id="spinner"
        class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">

        <!-- Logo Preloader -->
        <img src="{{ asset('img/logo.png') }}" alt="Loading..."
            style="width:120px; height:auto; animation: pulse 1.5s infinite;">
    </div>
    {{--  preloader End  --}}

    @yield('header', view('components.front.header'))

    @yield('content')

    @yield('footer', view('components.front.footer'))

    {{--  JavaScript Libraries  --}}
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('lib/easing/easing.min.js') }}"></script>
    <script src="{{ asset('lib/waypoints/waypoints.min.js') }}"></script>
    <script src="{{ asset('lib/owlcarousel/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('lib/lightbox/js/lightbox.min.js') }}"></script>

    {{--  Template Javascript   --}}
    <script src="{{ asset('js/main.js') }}"></script>
</body>

</html>
