<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\GalleryCategoryController;
use App\Http\Controllers\ImageGalleryController;
use App\Http\Controllers\VideoGalleryController;
use App\Http\Controllers\PackageCategoryController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\DestinationController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\TwoFactorAuthController;
use App\Models\Destination;


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';


// Show OTP form
Route::get('/2fa-verify', [TwoFactorAuthController::class, 'showVerifyForm'])->name('2fa.verify');

// Handle OTP verification
Route::post('/2fa-verify', [TwoFactorAuthController::class, 'verify'])->name('2fa.verify.post');


//----------------------------------------User routes---------------------------------------------------//
Route::get('/', function () {
    $destinations = Destination::orderBy('created_at', 'desc')->take(8)->get();
    return view('front.home', compact('destinations'));
})->name('home');

Route::get('/About', function () {
    return view('front.about');
})->name('about');

Route::get('/Destinations', [DestinationController::class, 'frontIndex'])->name('destinations');

Route::get('/Packages', [PackageController::class, 'frontIndex'])->name('packages');
Route::get('/Packages/{slug}', [PackageController::class, 'showFront'])->name('packages.show');

Route::get('/Video-Gallery', [VideoGalleryController::class, 'showGallery'])->name('video_gallery');

Route::get('/Image-Gallery', [ImageGalleryController::class, 'showGallery'])->name('image_gallery');

Route::get('/Blogs', function () {
    return view('front.blogs');
})->name('blogs');

Route::get('/Contact-Us', function () {
    return view('front.contact');
})->name('contact');

Route::post('/subscribe', [NewsletterController::class, 'store'])->name('newsletter.store');
Route::post('/contact/send', [ContactController::class, 'send'])->name('contact.send');
Route::post('/bookings', [BookingController::class, 'store'])->name('bookings.store');
Route::post('/reviews', [\App\Http\Controllers\ReviewController::class, 'store'])->name('reviews.store');



Route::get('/languages', function () {
    return view('front.languages');
})->name('languages.all');



//----------------------------------------Admin routes--------------------------------------------------//

Route::middleware(['auth', 'verified'])->get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');

// Admin Gallery Category Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/gallery-categories', [GalleryCategoryController::class, 'index'])->name('gallery-categories.index');
    Route::get('/gallery-categories/create', [GalleryCategoryController::class, 'create'])->name('gallery-categories.create');
    Route::post('/gallery-categories', [GalleryCategoryController::class, 'store'])->name('gallery-categories.store');
    Route::get('/gallery-categories/{galleryCategory}/edit', [GalleryCategoryController::class, 'edit'])->name('gallery-categories.edit');
    Route::put('/gallery-categories/{galleryCategory}', [GalleryCategoryController::class, 'update'])->name('gallery-categories.update');
    Route::delete('/gallery-categories/{galleryCategory}', [GalleryCategoryController::class, 'destroy'])->name('gallery-categories.destroy');
});

// Admin Image Gallery Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/image-gallery', [ImageGalleryController::class, 'index'])->name('image-gallery.index');
    Route::get('/image-gallery/create', [ImageGalleryController::class, 'create'])->name('image-gallery.create');
    Route::post('/image-gallery', [ImageGalleryController::class, 'store'])->name('image-gallery.store');
    Route::get('/image-gallery/{imageGallery}/edit', [ImageGalleryController::class, 'edit'])->name('image-gallery.edit');
    Route::put('/image-gallery/{imageGallery}', [ImageGalleryController::class, 'update'])->name('image-gallery.update');
    Route::delete('/image-gallery/{imageGallery}', [ImageGalleryController::class, 'destroy'])->name('image-gallery.destroy');
});

// Admin Video Gallery Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/video-gallery', [VideoGalleryController::class, 'index'])->name('video-gallery.index');
    Route::get('/video-gallery/create', [VideoGalleryController::class, 'create'])->name('video-gallery.create');
    Route::post('/video-gallery', [VideoGalleryController::class, 'store'])->name('video-gallery.store');
    Route::get('/video-gallery/{videoGallery}/edit', [VideoGalleryController::class, 'edit'])->name('video-gallery.edit');
    Route::put('/video-gallery/{videoGallery}', [VideoGalleryController::class, 'update'])->name('video-gallery.update');
    Route::delete('/video-gallery/{videoGallery}', [VideoGalleryController::class, 'destroy'])->name('video-gallery.destroy');
});


// Destination Routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Admin-Create-Destination', [DestinationController::class, 'create'])->name('destinations_create');
    Route::post('/Admin-Create-Destination', [DestinationController::class, 'store'])->name('destinations.store');
    Route::get('/Admin-All-Destinations', [DestinationController::class, 'index'])->name('destinations_all');
    Route::get('/Admin-Edit-Destination/{destination}', [DestinationController::class, 'edit'])->name('destinations.edit');
    Route::put('/Admin-Edit-Destination/{destination}', [DestinationController::class, 'update'])->name('destinations.update');
    Route::delete('/Admin-Delete-Destination/{destination}', [DestinationController::class, 'destroy'])->name('destinations.destroy');
});


//admins create routes here
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Create-New-Admin', [AdminController::class, 'create'])->name('admins_create');
    Route::post('/Create-New-Admin', [AdminController::class, 'store'])->name('admins_store');
    Route::get('/All-Admins', [AdminController::class, 'index'])->name('admins_all');
    Route::get('/All-Admins/{id}/edit', [AdminController::class, 'edit'])->name('admins_edit');
    Route::put('/All-Admins/{id}', [AdminController::class, 'update'])->name('admins_update');
    Route::delete('/All-Admins/{id}', [AdminController::class, 'destroy'])->name('admins_destroy');
});


// Admin Main Categories Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/main-categories', [PackageCategoryController::class, 'index'])->name('main-categories.index');
    Route::get('/main-categories/create', [PackageCategoryController::class, 'create'])->name('main-categories.create');
    Route::post('/main-categories', [PackageCategoryController::class, 'store'])->name('main-categories.store');
    Route::get('/main-categories/{category}/edit', [PackageCategoryController::class, 'edit'])->name('main-categories.edit');
    Route::put('/main-categories/{category}', [PackageCategoryController::class, 'update'])->name('main-categories.update');
    Route::delete('/main-categories/{category}', [PackageCategoryController::class, 'destroy'])->name('main-categories.destroy');
});

//Admin Sub Categories Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/sub-categories', [SubCategoryController::class, 'index'])->name('sub-categories.index');
    Route::get('/sub-categories/create', [SubCategoryController::class, 'create'])->name('sub-categories.create');
    Route::post('/sub-categories', [SubCategoryController::class, 'store'])->name('sub-categories.store');
    Route::get('/sub-categories/{subcategory}/edit', [SubCategoryController::class, 'edit'])->name('sub-categories.edit');
    Route::put('/sub-categories/{subcategory}', [SubCategoryController::class, 'update'])->name('sub-categories.update');
    Route::delete('/sub-categories/{subcategory}', [SubCategoryController::class, 'destroy'])->name('sub-categories.destroy');
});

//Admin Sub Categories Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/sub-categories', [SubCategoryController::class, 'index'])->name('sub-categories.index');
    Route::get('/sub-categories/create', [SubCategoryController::class, 'create'])->name('sub-categories.create');
    Route::post('/sub-categories', [SubCategoryController::class, 'store'])->name('sub-categories.store');
    Route::get('/sub-categories/{subcategory}/edit', [SubCategoryController::class, 'edit'])->name('sub-categories.edit');
    Route::put('/sub-categories/{subcategory}', [SubCategoryController::class, 'update'])->name('sub-categories.update');
    Route::delete('/sub-categories/{subcategory}', [SubCategoryController::class, 'destroy'])->name('sub-categories.destroy');
});


//Newsletter Routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Newsletter-Subscriptions', [NewsletterController::class, 'index'])->name('newsletter_admin');
    Route::delete('/Newsletter-Subscriptions/{id}', [NewsletterController::class, 'destroy'])->name('newsletter_destroy');
    Route::get('/Newsletter-Subscriptions/send', [NewsletterController::class, 'showCampaignForm'])->name('newsletter_campaign_form');
    Route::post('/Newsletter-Subscriptions/send', [NewsletterController::class, 'sendCampaign'])->name('newsletter_send_campaign');
});


//Event Routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Add-New-Event', [EventController::class, 'create'])->name('events_create');
    Route::post('/events', [EventController::class, 'store'])->name('events.store');
    Route::get('/All-Events', [EventController::class, 'index'])->name('events_all');
    Route::get('/events/data', [EventController::class, 'data'])->name('events.data');
    Route::get('/events/edit/{id}', [EventController::class, 'edit'])->name('events.edit');
    Route::put('/events/{id}', [EventController::class, 'update'])->name('events.update');
    Route::delete('/events/{id}', [EventController::class, 'destroy'])->name('events.destroy');
});


// Admin Packages Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {

    Route::get('/packages/{package}/Inclutions-Exlutions-images', [PackageController::class, 'package_inclution_exlution_details'])->name('package_inclution_exlution_details');

    Route::get('/packages', [PackageController::class, 'index'])->name('packages.index');
    Route::get('/packages/create', [PackageController::class, 'create'])->name('packages.create');
    Route::post('/packages', [PackageController::class, 'store'])->name('packages.store');
    Route::get('/packages/{package}/edit', [PackageController::class, 'edit'])->name('packages.edit');
    Route::put('/packages/{package}', [PackageController::class, 'update'])->name('packages.update');
    Route::delete('/packages/{package}', [PackageController::class, 'destroy'])->name('packages.destroy');

    Route::get('/packages/{package}/images', [PackageController::class, 'images'])->name('packages.images');
    Route::post('/packages/{package}/images', [PackageController::class, 'storeInclusionsExclusions'])->name('packages.images.store');
    // Per-item image manage routes
    Route::put('/packages/{package}/images/{image}', [PackageController::class, 'updatePackageImage'])->name('packages.images.update');
    Route::delete('/packages/{package}/images/{image}', [PackageController::class, 'destroyPackageImage'])->name('packages.images.destroy');
    // Inclusion item routes (index-based)
    Route::put('/packages/{package}/inclusions/{index}', [PackageController::class, 'updateInclusion'])->name('packages.inclusions.update');
    Route::delete('/packages/{package}/inclusions/{index}', [PackageController::class, 'destroyInclusion'])->name('packages.inclusions.destroy');
    // Exclusion item routes (index-based)
    Route::put('/packages/{package}/exclusions/{index}', [PackageController::class, 'updateExclusion'])->name('packages.exclusions.update');
    Route::delete('/packages/{package}/exclusions/{index}', [PackageController::class, 'destroyExclusion'])->name('packages.exclusions.destroy');
    Route::get('/packages/{package}/itineraries', [PackageController::class, 'itineraries'])->name('packages.itineraries');
    Route::get('/packages/{package}/itineraries-create', [PackageController::class, 'create_itineraries'])->name('packages.create_itineraries');
    Route::post('/packages/{package}/itineraries', [PackageController::class, 'storeItineraries'])->name('packages.itineraries.store');
});


Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/packages/{package}/itineraries/{itinerary}/edit', [PackageController::class, 'editItinerary'])->name('packages.itineraries.edit');
    Route::put('/packages/{package}/itineraries/{itinerary}', [PackageController::class, 'updateItinerary'])->name('packages.itineraries.update');
    Route::delete('/packages/{package}/itineraries/{itinerary}', [PackageController::class, 'destroyItinerary'])->name('packages.itineraries.destroy');
    Route::get('/packages/{package}/itineraries/{itinerary}/sub-itineraries', [PackageController::class, 'subItineraries'])->name('packages.itineraries.sub');

    // Sub-itineraries (Itinerary) CRUD routes (AJAX-friendly)
    Route::post('/packages/{package}/itineraries/{itinerary}/sub-itineraries', [PackageController::class, 'storeSubItinerary'])->name('packages.itineraries.sub.store');
    Route::put('/packages/{package}/itineraries/{itinerary}/sub-itineraries/{subItinerary}', [PackageController::class, 'updateSubItinerary'])->name('packages.itineraries.sub.update');
    Route::delete('/packages/{package}/itineraries/{itinerary}/sub-itineraries/{subItinerary}', [PackageController::class, 'destroySubItinerary'])->name('packages.itineraries.sub.destroy');
    Route::post('/packages/{package}/itineraries/{itinerary}/sub-itineraries/reorder', [PackageController::class, 'reorderSubItineraries'])->name('packages.itineraries.sub.reorder');
});


//Review Routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Reviews-all', [ReviewController::class, 'index'])->name('reviews_all');
    Route::patch('/reviews/{review}/status', [ReviewController::class, 'updateStatus'])->name('reviews.updateStatus');
    Route::delete('/reviews/{review}', [ReviewController::class, 'destroy'])->name('reviews.destroy');
});

//Inquiry Routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/Package-Inquries', [BookingController::class, 'index'])->name('package_inquries');
    Route::delete('/inquiries/{booking}', [BookingController::class, 'destroy'])->name('inquiries.destroy');
});


//activities(iteneries) routes
Route::middleware(['auth', 'verified'])->prefix('admin')->group(function () {
    Route::get('/packages/{package}/itineraries/{itinerary}/activities', [PackageController::class, 'activities'])->name('packages.itineraries.activities');
    // Return single activity as JSON for AJAX view/edit requests
    Route::get('/activities/{activity}', [PackageController::class, 'getActivity'])->name('activities.get');
    Route::post('/packages/{package}/itineraries/{itinerary}/activities', [PackageController::class, 'storeActivity'])->name('packages.itineraries.activities.store');
    Route::put('/packages/{package}/itineraries/{itinerary}/activities/{activity}', [PackageController::class, 'updateActivity'])->name('packages.itineraries.activities.update');
    Route::delete('/packages/{package}/itineraries/{itinerary}/activities/{activity}', [PackageController::class, 'destroyActivity'])->name('packages.itineraries.activities.destroy');
    Route::post('/packages/{package}/itineraries/{itinerary}/activities/reorder', [PackageController::class, 'reorderActivities'])->name('packages.itineraries.activities.reorder');
});
