<?php $__env->startSection('title', 'CEYLON THARU TOURS | DESTINATIONS'); ?>
<?php $__env->startSection('content'); ?>

<!-- Header Start -->
<div class="container-fluid bg-breadcrumb"
    style="background: url(<?php echo e(asset('img/destinations_header.jpg')); ?>) no-repeat center center;
            background-size: cover;
            background-attachment: fixed;">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">Travel Destinations</h3>
        <ol class="breadcrumb justify-content-center mb-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Pages</a></li>
            <li class="breadcrumb-item active text-white">Destinations</li>
        </ol>
    </div>
</div>
<!-- Header End -->

<!-- Map / Intro Row Start -->
<div class="container-fluid py-5">
    <div class="container">
        <div class="row align-items-center g-4">
            <!-- Left: Text Block -->
            <div class="col-lg-6">
                <div class="px-3">
                    <h5 class="section-title text-muted">Explore Destinations</h5>
                    <h2 class="mb-3">Our Tour Map</h2>
                    <p class="text-muted mb-4">Discover curated travel destinations across Sri Lanka. Click any marker
                        to view details, images and highlights. Plan your next adventure with our tailored tours.</p>
                    <a href="<?php echo e(route('packages')); ?>" class="btn btn-primary btn-lg rounded-pill">
                        <i class="fas fa-route me-2"></i>Find a Trip
                    </a>
                </div>
            </div>

            <!-- Right: Map Box -->
            <div class="col-lg-6">
                <div class="map-box" style="height: 500px;">
                    <div id="map"
                        style="height:100%; border-radius: 12px; box-shadow: 0 8px 30px rgba(33,37,41,0.08); overflow: hidden;">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Map / Intro Row End -->

<!-- Destination Start -->
<div class="container-fluid destination py-5">
    <div class="container py-5">
        <div class="mx-auto text-center mb-5" style="max-width: 900px;">
            <h5 class="section-title px-3">Destinations</h5>
            <h1 class="mb-0">Popular Destinations</h1>
        </div>
        <div class="tab-class">
            <div class="tab-content">
                <div id="tab-all" class="tab-pane fade show p-0 active">
                    <div class="row g-4">
                        <?php $__currentLoopData = $destinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-6 col-lg-3">
                                <div class="card destination-card h-100 border-0 shadow-sm">
                                    <div class="card-img-top overflow-hidden" style="height:200px;">
                                        <img src="<?php echo e($destination->image_path ? asset('storage/' . $destination->image_path) : asset('img/placeholder.jpg')); ?>"
                                            alt="<?php echo e($destination->name); ?>" class="w-100 h-100 object-fit-cover">
                                    </div>
                                    <div class="card-body d-flex flex-column">
                                        <h5 class="card-title mb-3"><?php echo e($destination->name); ?></h5>
                                        <p class="text-muted small mb-3" style="flex:1 1 auto;">
                                            <?php echo e(Str::limit($destination->description ?? 'No description available', 80)); ?>

                                        </p>
                                        <div class="mt-auto">
                                            <a href="#" class="btn btn-outline-primary w-100 view-destination"
                                                data-destination-id="<?php echo e($destination->id); ?>">View Details</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Destination End -->

<!-- Modal for Destination Details -->
<div class="modal fade" id="destinationModal" tabindex="-1" role="dialog" aria-labelledby="destinationModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content overflow-hidden" style="border-radius: 15px;">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="destinationModalLabel">
                    <i class="fas fa-map-marker-alt mr-2"></i> Destination Details
                </h5>
            </div>
            <div class="modal-body p-0">
                <div class="row no-gutters">
                    <div class="col-md-6 p-4">
                        <h3 id="modal-name" class="text-primary mb-3"></h3>

                        <div class="destination-info mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="icon-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mr-3"
                                    style="width: 40px; height: 40px;">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Location</h6>
                                    <p id="modal-address" class="mb-0 text-muted"></p>
                                </div>
                            </div>


                        </div>

                        <div class="mb-4">
                            <h5 class="border-bottom pb-2">Description</h5>
                            <p id="modal-description" class="text-justify"></p>
                        </div>

                        <div class="mb-4">
                            <h5 class="border-bottom pb-2">Key Highlights</h5>
                            <ul id="modal-key-points-list" class="list-unstyled"></ul>
                        </div>

                            <div class="mb-4">
                                <h5 class="border-bottom pb-2">Events</h5>
                                <div id="modal-events-list">
                                    <!-- Events will be injected here. If none, show a placeholder. -->
                                </div>
                            </div>
                    </div>
                    <div class="col-md-6">
                        <div id="modal-image-container" class="h-100 position-relative"
                            style="min-height: 400px; background: #f8f9fa;">
                            <img id="modal-image-src" src="" alt="Destination Image" class="w-100 h-100"
                                style="object-fit: cover;">
                            <div id="modal-no-image"
                                class="d-none h-100 d-flex align-items-center justify-content-center flex-column">
                                <i class="fas fa-image fa-4x text-muted mb-3"></i>
                                <p class="text-muted">No image available</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="modal-view-on-map">
                    <i class="fas fa-map-marked-alt mr-2"></i> View on Map
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<!-- Leaflet MarkerCluster CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.css" />
<link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.Default.css" />
<!-- Font Awesome for Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    /* Custom Map Styles */
    #map {
        position: relative;
        z-index: 1;
    }

    /* Custom Marker Styles */
    .custom-marker {
        background: #fff;
        border: 3px solid;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .custom-marker:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
    }

    .marker-pulse {
        display: block;
        border-radius: 50%;
        cursor: pointer;
        box-shadow: 0 0 0 rgba(0, 102, 204, 0.4);
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(0, 102, 204, 0.4);
        }

        70% {
            box-shadow: 0 0 0 15px rgba(0, 102, 204, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(0, 102, 204, 0);
        }
    }

    /* Custom Popup Styles */
    .leaflet-popup-content-wrapper {
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        overflow: hidden;
    }

    .leaflet-popup-content {
        margin: 0;
        width: 300px !important;
    }

    .custom-popup {
        padding: 0;
    }

    .popup-image {
        height: 150px;
        width: 100%;
        object-fit: cover;
    }

    .popup-content {
        padding: 15px;
    }

    .popup-title {
        font-size: 1.2rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 5px;
    }

    .popup-address {
        color: #7f8c8d;
        font-size: 0.9rem;
        margin-bottom: 10px;
    }

    .popup-description {
        color: #34495e;
        font-size: 0.9rem;
        margin-bottom: 15px;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .popup-button {
        display: block;
        width: 100%;
        text-align: center;
        padding: 8px 15px;
        background: linear-gradient(135deg, #3498db, #2c3e50);
        color: white;
        border-radius: 5px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .popup-button:hover {
        background: linear-gradient(135deg, #2980b9, #34495e);
        color: white;
        text-decoration: none;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    /* Modal Enhancements */
    .icon-circle {
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .destination-info h6 {
        font-weight: 600;
        color: #2c3e50;
    }

    /* Map Controls */
    .leaflet-control-zoom a {
        background: #fff;
        color: #2c3e50;
        border-radius: 4px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .leaflet-control-zoom a:hover {
        background: #f8f9fa;
    }

    /* Cluster Styles */
    .marker-cluster-custom {
        background: rgba(41, 128, 185, 0.7);
        border: 3px solid rgba(255, 255, 255, 0.8);
        border-radius: 50%;
        color: white;
        font-weight: bold;
        text-align: center;
    }

    .marker-cluster-custom div {
        background: rgba(52, 152, 219, 0.9);
        border-radius: 50%;
        width: 30px;
        height: 30px;
        margin: 5px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Animation for markers */
    @keyframes bounce {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(-10px);
        }
    }

    .marker-bounce {
        animation: bounce 1s infinite;
    }

    /* New: Destination cards and layout styles */
    .destination-card {
        border-radius: 12px;
        overflow: hidden;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .destination-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 18px 40px rgba(33, 37, 41, 0.08);
    }

    .object-fit-cover {
        object-fit: cover;
    }

    .map-box {
        border-radius: 12px;
        overflow: hidden;
        background: linear-gradient(180deg, #f8fbff, #f2f7f4);
        padding: 6px;
    }

    /* Responsive: stack and card image adjustments */
    @media (max-width: 767.98px) {
        .map-box {
            height: 320px !important;
        }

        .card-img-top {
            height: 180px !important;
        }
    }
</style>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://unpkg.com/leaflet.markercluster@1.5.3/dist/leaflet.markercluster.js"></script>

<script>
    // Initialize Leaflet map with enhanced options
    var map = L.map('map', {
        center: [7.8731, 80.7718], // Centered on Sri Lanka
        zoom: 7,
        zoomControl: true,
        fadeAnimation: true,
        zoomAnimation: true,
        preferCanvas: true
    });

    // Add a more visually appealing tile layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
        maxZoom: 18,
        detectRetina: true
    }).addTo(map);

    // Create marker cluster group for better visualization
    var markers = L.markerClusterGroup({
        chunkedLoading: true,
        maxClusterRadius: 60,
        spiderfyOnMaxZoom: true,
        showCoverageOnHover: true,
        zoomToBoundsOnClick: true,
        iconCreateFunction: function(cluster) {
            var count = cluster.getChildCount();
            var size = count < 10 ? 'small' : count < 50 ? 'medium' : 'large';
            return L.divIcon({
                html: '<div><span>' + count + '</span></div>',
                className: 'marker-cluster-custom marker-cluster-' + size,
                iconSize: L.point(40, 40)
            });
        }
    });

    // Color palette for destination markers
    const markerColors = [
        '#e74c3c', '#3498db', '#2ecc71', '#f39c12',
        '#9b59b6', '#1abc9c', '#d35400', '#c0392b',
        '#2980b9', '#27ae60', '#f1c40f', '#8e44ad'
    ];

    // Store markers for later reference
    const destinationMarkers = {};

    // Fetch destinations and add markers
    const destinations = <?php echo json_encode($destinations, 15, 512) ?>;

    destinations.forEach(function(destination, index) {
        let latlng;
        try {
            const coords = JSON.parse(destination.map_url);
            if (coords.latitude && coords.longitude) {
                latlng = L.latLng(coords.latitude, coords.longitude);
            } else {
                return; // Skip if no valid coordinates
            }
        } catch (e) {
            return; // Skip if map_url is invalid JSON
        }

        // Assign a color from the palette
        const color = markerColors[index % markerColors.length];

        // Create a custom marker with color and icon
        const customIcon = L.divIcon({
            className: 'custom-marker',
            html: `
                <div style="background: ${color}; width: 34px; height: 34px; border-radius: 50%; border: 3px solid white; display: flex; align-items: center; justify-content: center; color: white; font-size: 14px; box-shadow: 0 2px 5px rgba(0,0,0,0.2);">
                    <i class="fas fa-map-pin"></i>
                </div>
            `,
            iconSize: [40, 40],
            iconAnchor: [20, 40]
        });

        // Create marker with custom icon
        const marker = L.marker(latlng, {
            icon: customIcon,
            destinationId: destination.id
        });

        // Store marker reference
        destinationMarkers[destination.id] = marker;

        // Create popup content with enhanced styling
        const imageSrc = destination.image_path ? '/storage/' + destination.image_path :
            '<?php echo e(asset('img/placeholder.jpg')); ?>';
        const popupContent = `
            <div class="custom-popup">
                <img src="${imageSrc}" alt="${destination.name}" class="popup-image">
                <div class="popup-content">
                    <div class="popup-title">${destination.name}</div>
                    <div class="popup-address">${destination.address || 'Address not provided'}</div>
                    <div class="popup-description">${destination.description ? destination.description.substring(0, 120) + '...' : 'No description available'}</div>
                    <a href="#" class="popup-button view-destination" data-destination-id="${destination.id}">
                        <i class="fas fa-info-circle mr-1"></i> View Details
                    </a>
                </div>
            </div>
        `;

        marker.bindPopup(popupContent);

        // Add hover effects
        marker.on('mouseover', function() {
            this.openPopup();
        });

        // Add to cluster group
        markers.addLayer(marker);

        // Add click event to show modal with full details
        marker.on('click', function() {
            populateModal(destination);
            showDestinationModal();
        });
    });

    // Add markers to map
    map.addLayer(markers);

    // Function to populate modal with destination details
    function populateModal(destination) {
        document.getElementById('modal-name').textContent = destination.name;
        document.getElementById('modal-address').textContent = destination.address || 'Not provided';
        document.getElementById('modal-description').textContent = destination.description ||
        'No description available';

        // Handle key points
        const keyPointsList = document.getElementById('modal-key-points-list');
        keyPointsList.innerHTML = '';
        if (destination.key_points && Array.isArray(destination.key_points)) {
            destination.key_points.forEach(point => {
                const li = document.createElement('li');
                li.className = 'd-flex align-items-center mb-2';
                li.innerHTML = `
                    <i class="fas fa-check-circle text-success mr-2"></i>
                    <span>${point}</span>
                `;
                keyPointsList.appendChild(li);
            });
        } else {
            const li = document.createElement('li');
            li.className = 'text-muted';
            li.textContent = 'No key points available';
            keyPointsList.appendChild(li);
        }

        // Handle image
        const imageElement = document.getElementById('modal-image-src');
        const noImageElement = document.getElementById('modal-no-image');
        if (destination.image_path) {
            imageElement.src = '/storage/' + destination.image_path;
            imageElement.classList.remove('d-none');
            noImageElement.classList.add('d-none');
        } else {
            imageElement.classList.add('d-none');
            noImageElement.classList.remove('d-none');
        }

        // Populate events
        const eventsContainer = document.getElementById('modal-events-list');
        eventsContainer.innerHTML = '';
        if (destination.events && Array.isArray(destination.events) && destination.events.length > 0) {
            destination.events.forEach(ev => {
                const card = document.createElement('div');
                card.className = 'card mb-2 shadow-sm';
                card.innerHTML = `
                    <div class="card-body p-3">
                        <h6 class="mb-1">${ev.title || 'Untitled Event'}</h6>
                        <p class="mb-0 text-muted small">${ev.description ? ev.description.substring(0, 140) : ''}</p>
                    </div>
                `;
                eventsContainer.appendChild(card);
            });
        } else {
            const p = document.createElement('p');
            p.className = 'text-muted small mb-0';
            p.textContent = 'No upcoming events for this destination.';
            eventsContainer.appendChild(p);
        }

        // Set view on map button functionality
        document.getElementById('modal-view-on-map').onclick = function() {
            hideDestinationModal();

            // Find and open the marker's popup
            const marker = destinationMarkers[destination.id];
            if (marker) {
                map.setView(marker.getLatLng(), 12, {
                    animate: true,
                    duration: 1
                });

                // Briefly highlight the marker
                const icon = marker.getElement();
                if (icon) {
                    icon.classList.add('marker-bounce');
                    setTimeout(() => {
                        icon.classList.remove('marker-bounce');
                    }, 2000);
                }

                setTimeout(() => {
                    marker.openPopup();
                }, 800);
            }
        };
    }

    // Handle click events for "View Details" buttons
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('view-destination') || e.target.closest('.view-destination')) {
            e.preventDefault();
            const button = e.target.classList.contains('view-destination') ? e.target : e.target.closest(
                '.view-destination');
            const destinationId = button.getAttribute('data-destination-id');
            const destination = destinations.find(d => d.id == destinationId);
            if (destination) {
                populateModal(destination);
                showDestinationModal();
            }
        }
    });

    // Add a scale control to the map
    L.control.scale({
        imperial: false
    }).addTo(map);

    // Helper functions to show/hide modal using Bootstrap 5 API with jQuery fallback
    function getDestinationModalInstance() {
        const modalEl = document.getElementById('destinationModal');
        if (!modalEl) return null;
        // If bootstrap global is available (bundled JS), use its Modal API
        if (window.bootstrap && typeof window.bootstrap.Modal === 'function') {
            // Store instance on element to reuse
            if (!modalEl._bsModal) {
                modalEl._bsModal = new bootstrap.Modal(modalEl, {
                    backdrop: true
                });
            }
            return modalEl._bsModal;
        }
        // Fallback: return null (we'll use jQuery calls in show/hide functions)
        return null;
    }

    function showDestinationModal() {
        const inst = getDestinationModalInstance();
        if (inst) {
            inst.show();
        } else if (window.jQuery) {
            $('#destinationModal').modal('show');
        }
    }

    function hideDestinationModal() {
        const inst = getDestinationModalInstance();
        if (inst) {
            inst.hide();
        } else if (window.jQuery) {
            $('#destinationModal').modal('hide');
        }
    }

    // Fit map to show all markers with some padding
    setTimeout(function() {
        if (Object.keys(destinationMarkers).length > 0) {
            const group = new L.featureGroup(Object.values(destinationMarkers));
            map.fitBounds(group.getBounds(), {
                padding: [20, 20]
            });
        }
    }, 1000);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/front/destinations.blade.php ENDPATH**/ ?>