<?php $__env->startSection('title', 'CEYLON THARU TRAVELS | PACKAGE ITINERARIES'); ?>

<?php $__env->startSection('content_admin'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Itineraries for <?php echo e($package->title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('packages.index')); ?>">Packages</a></li>
                            <li class="breadcrumb-item active">Itineraries</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Existing Itineraries</h3>
                        <div class="card-tools">
                            <a href="<?php echo e(route('packages.create_itineraries', $package->id)); ?>"
                                class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Create Itinerary
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if($itineraries->isEmpty()): ?>
                            <p>No itineraries found for this package.</p>
                        <?php else: ?>
                            <div class="timeline">
                                <?php $__currentLoopData = $itineraries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itinerary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div>
                                        <i class="fas fa-map-marker-alt bg-primary"></i>
                                        <div class="timeline-item">
                                            <h3 class="timeline-header">Day <?php echo e($itinerary->day_number); ?>:
                                                <?php echo e($itinerary->title); ?></h3>
                                            <div class="timeline-body">
                                                <?php if($itinerary->images->isNotEmpty()): ?>
                                                    <div class="row mb-3">
                                                        <?php $__currentLoopData = $itinerary->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-md-4">
                                                                <div class="card card-outline card-primary">
                                                                    <div class="card-body p-2">
                                                                        <img src="<?php echo e(Storage::url($image->image_path)); ?>"
                                                                            class="img-fluid rounded"
                                                                            style="max-height: 150px; width: 100%; object-fit: cover;"
                                                                            alt="<?php echo e($image->caption ?? 'Itinerary Image'); ?>">
                                                                        <p class="mt-2 text-sm text-center">
                                                                            <?php echo e($image->caption ?? 'No caption'); ?></p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php else: ?>
                                                    <p class="text-muted">No images available for this day.</p>
                                                <?php endif; ?>
                                                <?php
                                                    $subItineraries = \App\Models\Itinerary::where(
                                                        'package_itinerary_id',
                                                        $itinerary->id,
                                                    )
                                                        ->ordered()
                                                        ->get();
                                                ?>
                                                <?php if($subItineraries->isNotEmpty()): ?>
                                                    <h5 class="mt-3">Plan</h5>
                                                    <ul class="list-group mb-3">
                                                        <?php $__currentLoopData = $subItineraries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subItinerary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="list-group-item">
                                                                <strong> <?php echo e($subItinerary->order); ?>:</strong>
                                                                <?php echo e($subItinerary->detail); ?>

                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                <?php else: ?>
                                                    <p class="text-muted">No sub-itineraries available for this day.</p>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <div class="timeline-body">
                                                <?php if(isset($itinerary->activities) && $itinerary->activities->isNotEmpty()): ?>
                                                    <h5 class="mt-3">Activities</h5>
                                                    <ul class="list-group mb-3">
                                                        <?php $__currentLoopData = $itinerary->activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="list-group-item">
                                                                <div class="d-flex align-items-start">
                                                                    <?php if($activity->image_path): ?>
                                                                        <img src="<?php echo e(asset($activity->image_path)); ?>"
                                                                            alt="<?php echo e($activity->name); ?>"
                                                                            style="height:60px; width:80px; object-fit:cover;"
                                                                            class="mr-3">
                                                                    <?php endif; ?>
                                                                    <div class="flex-grow-1">
                                                                        <div class="d-flex justify-content-between">
                                                                            <div>
                                                                                <strong><?php echo e($activity->name); ?></strong>
                                                                                <div class="text-muted small">
                                                                                    <?php echo e(Str::limit($activity->description, 120)); ?>

                                                                                </div>
                                                                                <div class="text-muted small">Added:
                                                                                    <?php echo e($activity->created_at ? $activity->created_at->format('Y-m-d') : ''); ?>

                                                                                </div>
                                                                            </div>

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(isset($itinerary->activities_count) && $itinerary->activities_count > 3): ?>
                                                            <li class="list-group-item text-center">
                                                                <a
                                                                    href="<?php echo e(route('packages.itineraries.activities', [$package->id, $itinerary->id])); ?>">View
                                                                    all activities (<?php echo e($itinerary->activities_count); ?>)</a>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                            <div class="timeline-footer">
                                                <a href="<?php echo e(route('packages.itineraries.edit', [$package->id, $itinerary->id])); ?>"
                                                    class="btn btn-primary btn-sm">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <form
                                                    action="<?php echo e(route('packages.itineraries.destroy', [$package->id, $itinerary->id])); ?>"
                                                    method="POST" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this itinerary?');">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                                <a href="<?php echo e(route('packages.itineraries.sub', [$package->id, $itinerary->id])); ?>"
                                                    class="btn btn-info btn-sm">
                                                    <i class="fas fa-list"></i> Sub-Itineraries
                                                </a>
                                                <a href="<?php echo e(route('packages.itineraries.activities', [$package->id, $itinerary->id])); ?>"
                                                    class="btn btn-success  btn-sm">
                                                    <i class="fas fa-hiking"></i> Activities
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="card card-outline card-primary mt-4">
                                <div class="card-header">
                                    <h3 class="card-title">Tour Route Map</h3>
                                </div>
                                <div class="card-body">
                                    <div id="tour-map" style="height: 400px;"></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </section>
    </div>

    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.css" />

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script src="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.js"></script>

    <script>
        <?php if(!$itineraries->isEmpty()): ?>
            // Initialize the tour map
            var tourMap = L.map('tour-map').setView([6.9041, 79.8977], 8);

            // Add tile layer
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap contributors'
            }).addTo(tourMap);

            // Starting point: Bandaranaike International Airport
            var startPoint = [6.9041, 79.8977];

            // Add airport marker with custom icon
            L.marker(startPoint, {
                icon: L.divIcon({
                    className: 'custom-div-icon',
                    html: '<div style="background-color: red; width: 20px; height: 20px; border-radius: 50%; border: 2px solid white;"><i class="fas fa-plane" style="color: white; font-size: 10px; margin: 2px 0 0 3px;"></i></div>',
                    iconSize: [20, 20],
                    iconAnchor: [10, 10]
                })
            }).addTo(tourMap).bindPopup('Bandaranaike International Airport (Start)');

            // Collect all waypoints
            var waypoints = [L.latLng(startPoint[0], startPoint[1])];

            // Add itinerary markers and collect waypoints
            <?php $__currentLoopData = $itineraries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $itinerary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                var coords<?php echo e($index); ?> = JSON.parse('<?php echo $itinerary->map_url; ?>');
                waypoints.push(L.latLng(coords<?php echo e($index); ?>.lat, coords<?php echo e($index); ?>.lng));

                // Add numbered marker for each itinerary
                L.marker([coords<?php echo e($index); ?>.lat, coords<?php echo e($index); ?>.lng], {
                    icon: L.divIcon({
                        className: 'custom-div-icon',
                        html: '<div style="background-color: blue; color: white; width: 25px; height: 25px; border-radius: 50%; border: 2px solid white; text-align: center; line-height: 21px; font-weight: bold; font-size: 12px;"><?php echo e($itinerary->day_number); ?></div>',
                        iconSize: [25, 25],
                        iconAnchor: [12.5, 12.5]
                    })
                }).addTo(tourMap).bindPopup(
                    '<strong>Day <?php echo e($itinerary->day_number); ?>:</strong><br><?php echo e($itinerary->title); ?>');
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            // Create routing control with real road routing
            var routingControl = L.Routing.control({
                waypoints: waypoints,
                routeWhileDragging: false,
                addWaypoints: false,
                createMarker: function() {
                    return null;
                }, // Don't create default markers
                lineOptions: {
                    styles: [{
                        color: '#2E86C1',
                        weight: 4,
                        opacity: 0.8
                    }]
                },
                router: L.Routing.osrmv1({
                    serviceUrl: 'https://router.project-osrm.org/route/v1'
                }),
                show: false, // Hide turn-by-turn instructions
                routeWhileDragging: false,
                fitSelectedRoutes: true
            }).addTo(tourMap);

            // Optional: Handle routing events
            routingControl.on('routesfound', function(e) {
                var routes = e.routes;
                var summary = routes[0].summary;
                console.log('Total distance: ' + (summary.totalDistance / 1000).toFixed(2) + ' km');
                console.log('Total time: ' + Math.round(summary.totalTime / 60) + ' minutes');
            });

            // Add a legend
            var legend = L.control({
                position: 'bottomright'
            });
            legend.onAdd = function(map) {
                var div = L.DomUtil.create('div', 'info legend');
                div.innerHTML =
                    '<div style="background: white; padding: 10px; border-radius: 5px; box-shadow: 0 0 5px rgba(0,0,0,0.3);">' +
                    '<div><span style="display: inline-block; width: 20px; height: 20px; background: red; border-radius: 50%; margin-right: 5px; vertical-align: middle;"></span> Airport (Start)</div>' +
                    '<div style="margin-top: 5px;"><span style="display: inline-block; width: 20px; height: 20px; background: blue; border-radius: 50%; margin-right: 5px; vertical-align: middle;"></span> Tour Destinations</div>' +
                    '<div style="margin-top: 5px;"><span style="display: inline-block; width: 20px; height: 2px; background: #2E86C1; margin-right: 5px; vertical-align: middle;"></span> Tour Route</div>' +
                    '</div>';
                return div;
            };
            legend.addTo(tourMap);
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/package_iteneries/package_iteneries.blade.php ENDPATH**/ ?>