<?php $__env->startSection('title', 'CEYLON THARU TOURS | VIDEO GALLERY'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h3 class="text-white display-3 mb-4">Our Video Gallery</h3>
            <ol class="breadcrumb justify-content-center mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Pages</a></li>
                <li class="breadcrumb-item active text-white">Video Gallery</li>
            </ol>
        </div>
    </div>
    <!-- Header End -->

    <!-- Gallery Start -->
    <div class="container-fluid gallery py-5 my-5">
        <div class="mx-auto text-center mb-5" style="max-width: 900px;">
            <h5 class="section-title px-3">Our Video Gallery</h5>
            <h1 class="mb-4">Tourism & Traveling Video Gallery</h1>
            <p class="mb-0">Lorem ipsum dolor sit amet consectetur adipisicing elit. Laborum tempore nam, architecto doloremque velit explicabo? Voluptate sunt eveniet fuga eligendi! Expedita laudantium fugiat corrupti eum cum repellat a laborum quasi.</p>
        </div>
        <div class="tab-class text-center">
            <ul class="nav nav-pills d-inline-flex justify-content-center mb-5">
                <li class="nav-item">
                    <a class="d-flex mx-3 py-2 border border-primary bg-light rounded-pill active" data-bs-toggle="pill" href="#GalleryTab-all">
                        <span class="text-dark" style="width: 150px;">All</span>
                    </a>
                </li>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="d-flex py-2 mx-3 border border-primary bg-light rounded-pill" data-bs-toggle="pill" href="#GalleryTab-<?php echo e($category->id); ?>">
                            <span class="text-dark" style="width: 150px;"><?php echo e($category->name); ?></span>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <div class="tab-content">
                <!-- All Videos Tab -->
                <div id="GalleryTab-all" class="tab-pane fade show p-0 active">
                    <div class="row g-2">
                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-<?php echo e(in_array($video->id % 10, [1, 3, 5, 8]) ? 2 : 3); ?>">
                                <div class="gallery-item h-100">
                                    <?php if(strpos($video->video_url, 'youtube.com') !== false): ?>
                                        <!-- YouTube Video -->
                                        <img src="https://img.youtube.com/vi/<?php echo e(parse_url($video->video_url, PHP_URL_PATH)); ?>/hqdefault.jpg" class="img-fluid w-100 h-100 rounded" alt="<?php echo e($video->title); ?>">
                                        <div class="gallery-content">
                                            <div class="gallery-info">
                                                <h5 class="text-white text-uppercase mb-2"><?php echo e($video->category->name); ?></h5>
                                                <a href="#" class="btn-hover text-white">View All Place <i class="fa fa-arrow-right ms-2"></i></a>
                                            </div>
                                        </div>
                                        <div class="gallery-plus-icon">
                                            <a href="<?php echo e($video->video_url); ?>" data-lightbox="gallery-<?php echo e($video->id); ?>" data-type="iframe" class="my-auto"><i class="fas fa-play fa-2x text-white"></i></a>
                                        </div>
                                    <?php else: ?>
                                        <!-- Uploaded Video -->
                                        

                                                             <video controls class="card-img-top"
                                                            style="max-height: 200px; object-fit: cover; border-top-left-radius: .25rem; border-top-right-radius: .25rem;">
                                                            <source src="<?php echo e(asset('storage/' . $video->video_url)); ?>"
                                                                type="video/mp4">
                                                            Your browser does not support the video tag.
                                                        </video>
                                        <div class="gallery-content">
                                            <div class="gallery-info">
                                                <h5 class="text-white text-uppercase mb-2"><?php echo e($video->category->name); ?></h5>
                                                <div class="btn-hover text-white"><?php echo e($video->title); ?> </div>
                                            </div>
                                        </div>
                                        <div class="gallery-plus-icon">
                                            <a href="<?php echo e(asset('storage/' . $video->video_url)); ?>" data-lightbox="gallery-<?php echo e($video->id); ?>" class="my-auto"><i class="fas fa-play fa-2x text-white"></i></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <!-- Category-specific Tabs -->
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div id="GalleryTab-<?php echo e($category->id); ?>" class="tab-pane fade show p-0">
                        <div class="row g-2">
                            <?php $__currentLoopData = $videos->where('category_id', $category->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-6 col-md-6 col-lg-4 col-xl-<?php echo e(in_array($video->id % 10, [1, 3, 5, 8]) ? 2 : 3); ?>">
                                    <div class="gallery-item h-100">
                                        <?php if(strpos($video->video_url, 'youtube.com') !== false): ?>
                                            <!-- YouTube Video -->
                                            <img src="https://img.youtube.com/vi/<?php echo e(parse_url($video->video_url, PHP_URL_PATH)); ?>/hqdefault.jpg" class="img-fluid w-100 h-100 rounded" alt="<?php echo e($video->title); ?>">
                                            <div class="gallery-content">
                                                <div class="gallery-info">
                                                    <h5 class="text-white text-uppercase mb-2"><?php echo e($category->name); ?></h5>
                                                    <div class="btn-hover text-white"><?php echo e($video->title); ?> <i class="fa fa-arrow-right ms-2"></i></div>
                                                </div>
                                            </div>
                                            <div class="gallery-plus-icon">
                                                <a href="<?php echo e($video->video_url); ?>" data-lightbox="gallery-<?php echo e($video->id); ?>" data-type="iframe" class="my-auto"><i class="fas fa-play fa-2x text-white"></i></a>
                                            </div>
                                        <?php else: ?>
                                            <!-- Uploaded Video -->
                                            

                                                        <video controls class="card-img-top"
                                                            style="max-height: 200px; object-fit: cover; border-top-left-radius: .25rem; border-top-right-radius: .25rem;">
                                                            <source src="<?php echo e(asset('storage/' . $video->video_url)); ?>"
                                                                type="video/mp4">
                                                            Your browser does not support the video tag.
                                                        </video>
                                            <div class="gallery-content">
                                                <div class="gallery-info">
                                                    <h5 class="text-white text-uppercase mb-2"><?php echo e($category->name); ?></h5>
                                                    <a href="#" class="btn-hover text-white">View All Place </a>
                                                </div>
                                            </div>
                                            <div class="gallery-plus-icon">
                                                <a href="<?php echo e(asset('storage/' . $video->video_url)); ?>" data-lightbox="gallery-<?php echo e($video->id); ?>" class="my-auto"><i class="fas fa-play fa-2x text-white"></i></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <!-- Gallery End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/front/video_gallery.blade.php ENDPATH**/ ?>