<?php $__env->startSection('title', 'Manage Package Inclusions / Exclusions'); ?>

<?php $__env->startSection('content_admin'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Manage Images, Inclusions & Exclusions - <?php echo e($package->title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('packages.index')); ?>">Tour Packages</a></li>
                            <li class="breadcrumb-item active">Manage</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                        <?php endif; ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Images</h3>
                                <div class="card-tools">
                                    <a href="<?php echo e(route('packages.images', $package->id)); ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-plus"></i> Add New Images, Inclusions & Exclusions
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <p class="text-muted">Showing up to 4 images for this package. To add or manage images,
                                    use the "Add New Images, Inclusions & Exclusions" button at the top.</p>

                                <div class="row mb-3">
                                    <?php $displayImages = $images->take(4); ?>
                                    <?php if($displayImages->isEmpty()): ?>
                                        <div class="col-12">
                                            <p class="text-muted">No images uploaded yet.</p>
                                        </div>
                                    <?php else: ?>
                                        <?php $__currentLoopData = $displayImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-3 mb-3">
                                                <div style="border:1px solid #e3e3e3; padding:8px; text-align:center;">
                                                    <img src="<?php echo e(asset($img->image_path)); ?>" alt="image"
                                                        style="max-width:100%; height:120px; object-fit:cover;" />
                                                    <?php if($img->caption): ?>
                                                        <p class="mt-2"><strong><?php echo e($img->caption); ?></strong></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>Inclusions</h5>
                                        <?php if(!empty($inclusions) && count($inclusions)): ?>
                                            <ul class="list-group">
                                                <?php $__currentLoopData = $inclusions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-group-item"><?php echo e($inc); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No inclusions specified.</p>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <h5>Exclusions</h5>
                                        <?php if(!empty($exclusions) && count($exclusions)): ?>
                                            <ul class="list-group">
                                                <?php $__currentLoopData = $exclusions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-group-item"><?php echo e($exc); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No exclusions specified.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <a href="<?php echo e(route('packages.index')); ?>" class="btn btn-secondary">Back</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>
    </div>

    <!-- No JS required for display-only view -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/package/package_inclution_exlution.blade.php ENDPATH**/ ?>