<?php $__env->startSection('title', 'CEYLON THARU TRAVELS | ADMIN IMAGE GALLERY'); ?>
<?php $__env->startSection('content_admin'); ?>

    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Image Gallery</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Image Gallery</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-check"></i> Success!</h5>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <h5><i class="icon fas fa-ban"></i> Error!</h5>
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <div class="row">
                    <div class="col-12">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h4 class="card-title">Image Gallery Management</h4>
                                <div class="card-tools">
                                    <a href="<?php echo e(route('image-gallery.create')); ?>" class="btn btn-primary">
                                        <i class="fas fa-plus"></i> Add New Image
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Filter Controls -->
                                <div>
                                    <div class="btn-group w-100 mb-2">
                                        <a class="btn btn-info active" href="javascript:void(0)" data-filter="all">
                                            All Images (<?php echo e($images->count()); ?>)
                                        </a>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="btn btn-info" href="javascript:void(0)"
                                                data-filter="<?php echo e($category->id); ?>">
                                                <?php echo e($category->name); ?> (<?php echo e($category->images->count()); ?>)
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="mb-2">
                                        <a class="btn btn-secondary" href="javascript:void(0)" data-shuffle>
                                            Shuffle Images
                                        </a>
                                        <div class="float-right">
                                            <select class="custom-select" style="width: auto;" data-sortOrder>
                                                <option value="index"> Sort by Position </option>
                                                <option value="sortData"> Sort by Title </option>
                                            </select>
                                            <div class="btn-group">
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortAsc> Ascending
                                                </a>
                                                <a class="btn btn-default" href="javascript:void(0)" data-sortDesc>
                                                    Descending </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Image Gallery Grid -->
                                <div>
                                    <div class="filter-container p-0 row">
                                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="filtr-item col-sm-2 mb-3" data-category="<?php echo e($image->category_id); ?>"
                                                data-sort="<?php echo e($image->title); ?>">
                                                <div class="image-container position-relative">
                                                    <a href="<?php echo e(Storage::url($image->image_path)); ?>" data-toggle="lightbox"
                                                        data-title="<?php echo e($image->title); ?> - <?php echo e($image->category->name); ?>"
                                                        data-gallery="gallery">
                                                        <img src="<?php echo e(Storage::url($image->image_path)); ?>"
                                                            class="img-fluid mb-2 gallery-image" alt="<?php echo e($image->title); ?>"
                                                            style="height: 150px; object-fit: cover; width: 100%;">
                                                    </a>
                                                    <div class="image-actions position-absolute top-0 right-0 p-1">
                                                        <a href="<?php echo e(route('image-gallery.edit', $image->id)); ?>"
                                                            class="btn btn-warning btn-xs" title="Edit">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <form action="<?php echo e(route('image-gallery.destroy', $image->id)); ?>"
                                                            method="POST" style="display: inline-block;"
                                                            onsubmit="return confirm('Are you sure you want to delete this image: <?php echo e($image->title); ?>? This action cannot be undone!')">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn btn-danger btn-xs"
                                                                title="Delete">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                    <div class="image-info">
                                                        <small
                                                            class="text-muted d-block"><?php echo e(Str::limit($image->title, 20)); ?></small>
                                                        <small
                                                            class="badge badge-info"><?php echo e($image->category->name); ?></small>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php if($images->isEmpty()): ?>
                                            <div class="col-12 text-center py-5">
                                                <i class="fas fa-images fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No images found in the gallery.</p>
                                                <a href="<?php echo e(route('image-gallery.create')); ?>" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Image
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <style>
        .image-container {
            transition: transform 0.3s ease;
        }

        .image-container:hover {
            transform: scale(1.05);
        }

        .image-actions {
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .image-container:hover .image-actions {
            opacity: 1;
        }

        .gallery-image {
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .filtr-item {
            margin-bottom: 20px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/image_gallery_admin.blade.php ENDPATH**/ ?>