  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <!-- Left navbar links -->
      <ul class="navbar-nav">
          <li class="nav-item">
              <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
          </li>
      </ul>

      <!-- Right navbar links -->
      <ul class="navbar-nav ml-auto">
          <li class="nav-item">
              <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                  <i class="fas fa-expand-arrows-alt"></i>
              </a>
          </li>
      </ul>
  </nav>
  <!-- /.navbar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
      <!-- Brand Logo -->
      <a href="<?php echo e(route('home')); ?>" class="brand-link">
          <img src="<?php echo e(asset('img/logo.png')); ?>" alt="Logo" class="brand-image img-circle elevation-3"
              style="opacity: .8">
          <span class="brand-text font-weight-light">
              
              TRAVELS
          </span>
      </a>

      <!-- Sidebar -->
      <div class="sidebar">
          <!-- Sidebar user panel -->
          <div class="user-panel mt-3 pb-3 mb-3 d-flex">
              <div class="info">
                  <?php if(auth()->guard()->check()): ?>
                      <a href="#" class="d-block">Welcome, <strong><?php echo e(Auth::user()->name); ?></strong></a>
                  <?php else: ?>
                      <a href="<?php echo e(route('login')); ?>" class="d-block"><strong>Guest</strong></a>
                  <?php endif; ?>
              </div>
          </div>

          <!-- Sidebar Menu -->
          <nav class="mt-2">
              <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                  data-accordion="false">

                  <!-- Dashboard -->
                  <li class="nav-item">
                      <a href="<?php echo e(route('dashboard')); ?>"
                          class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-tachometer-alt"></i>
                          <p>Dashboard</p>
                      </a>
                  </li>

                  
                  <li class="nav-item">
                      <a href="<?php echo e(route('packages.index')); ?>"
                          class="nav-link <?php echo e(request()->routeIs('packages.index') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-box-open"></i>
                          <p>Packages</p>
                      </a>
                  </li>

                  
                  <li class="nav-item">
                      <a href="<?php echo e(route('package_inquries')); ?>"
                          class="nav-link <?php echo e(request()->routeIs('package_inquries') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-inbox"></i>
                          <p>Inquiries</p>
                      </a>
                  </li>

                  
                  <li class="nav-item">
                      <a href="<?php echo e(route('newsletter_admin')); ?>"
                          class="nav-link <?php echo e(request()->routeIs('newsletter_admin') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-envelope-open-text"></i>
                          <p>Email Campaign</p>
                      </a </li>


                      
                  <li class="nav-item">
                      <a href="<?php echo e(route('reviews_all')); ?>"
                          class="nav-link <?php echo e(request()->routeIs('reviews_all') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-star"></i>
                          <p>Reviews</p>
                      </a>
                  </li>


                  
                  <li
                      class="nav-item <?php echo e(request()->routeIs('image-gallery.index') || request()->routeIs('video-gallery.index') || request()->routeIs('gallery-categories.index') ? 'menu-open' : ''); ?>">
                      <a href="#"
                          class="nav-link <?php echo e(request()->routeIs('image-gallery.index') || request()->routeIs('video-gallery.index') || request()->routeIs('gallery-categories.index') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-box"></i>
                          <p>
                              Gallery
                              <i class="right fas fa-angle-left"></i>
                          </p>
                      </a>
                      <ul class="nav nav-treeview">
                          <li class="nav-item">
                              <a href="<?php echo e(route('gallery-categories.index')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('gallery-categories.index') ? 'active' : ''); ?>">
                                  <i class="fas fa-list-alt nav-icon"></i>
                                  <p>Gallery Tour Category</p>
                              </a>
                          </li>
                          <li class="nav-item">
                              <a href="<?php echo e(route('image-gallery.index')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('image-gallery.index') ? 'active' : ''); ?>">
                                  <i class="fas fa-list-alt nav-icon"></i>
                                  <p>Image Gallery</p>
                              </a>
                          </li>
                          <li class="nav-item">
                              <a href="<?php echo e(route('video-gallery.index')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('video-gallery.index') ? 'active' : ''); ?>">
                                  <i class="fas fa-plus-circle nav-icon"></i>
                                  <p>Video Gallery</p>
                              </a>
                          </li>
                      </ul>
                  </li>

                  
                  <li
                      class="nav-item <?php echo e(request()->routeIs('destinations_all') || request()->routeIs('destinations_create') ? 'menu-open' : ''); ?>">
                      <a href="#"
                          class="nav-link <?php echo e(request()->routeIs('destinations_all') || request()->routeIs('destinations_create') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-map-marked-alt"></i>
                          <p>
                              Destinations
                              <i class="right fas fa-angle-left"></i>
                          </p>
                      </a>
                      <ul class="nav nav-treeview">
                          <!-- All Destinations -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('destinations_all')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('destinations_all') ? 'active' : ''); ?>">
                                  <i class="fas fa-list nav-icon"></i>
                                  <p>All Destinations</p>
                              </a>
                          </li>
                          <!-- Add New Destination -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('destinations_create')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('destinations_create') ? 'active' : ''); ?>">
                                  <i class="fas fa-plus-circle nav-icon"></i>
                                  <p>Add New Destination</p>
                              </a>
                          </li>

                          <!-- All Events -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('events_all')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('events_all') ? 'active' : ''); ?>">
                                  <i class="fas fa-calendar-alt nav-icon"></i>
                                  <p>All Events</p>
                              </a>
                          </li>

                          <!-- Add New Event -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('events_create')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('events_create') ? 'active' : ''); ?>">
                                  <i class="fas fa-plus-circle nav-icon"></i>
                                  <p>Add New Event</p>
                              </a>
                          </li>
                      </ul>
                  </li>


                  
                  <li
                      class="nav-item <?php echo e(request()->routeIs('admins_all') || request()->routeIs('admins_create') ? 'menu-open' : ''); ?>">
                      <a href="#"
                          class="nav-link <?php echo e(request()->routeIs('admins_all') || request()->routeIs('admins_create') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-user-shield"></i>
                          <p>
                              Admins
                              <i class="right fas fa-angle-left"></i>
                          </p>
                      </a>
                      <ul class="nav nav-treeview">
                          <!-- All Admins -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('admins_all')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('admins_all') ? 'active' : ''); ?>">
                                  <i class="fas fa-users nav-icon"></i>
                                  <p>All Admins</p>
                              </a>
                          </li>
                          <!-- Create New Admin -->
                          <li class="nav-item">
                              <a href="<?php echo e(route('admins_create')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('admins_create') ? 'active' : ''); ?>">
                                  <i class="fas fa-user-plus nav-icon"></i>
                                  <p>Create New Admin</p>
                              </a>
                          </li>
                      </ul>
                  </li>


                  
                  <li
                      class="nav-item <?php echo e(request()->routeIs('main-categories.index') || request()->routeIs('sub-categories.index') ? 'menu-open' : ''); ?>">
                      <a href="#"
                          class="nav-link <?php echo e(request()->routeIs('main-categories.index') || request()->routeIs('sub-categories.index') ? 'active' : ''); ?>">
                          <i class="nav-icon fas fa-box"></i>
                          <p>
                              Package Categories
                              <i class="right fas fa-angle-left"></i>
                          </p>
                      </a>
                      <ul class="nav nav-treeview">
                          <li class="nav-item">
                              <a href="<?php echo e(route('main-categories.index')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('main-categories.index') ? 'active' : ''); ?>">
                                  <i class="fas fa-list-alt nav-icon"></i>
                                  <p>Main Category</p>
                              </a>
                          </li>
                          <li class="nav-item">
                              <a href="<?php echo e(route('sub-categories.index')); ?>"
                                  class="nav-link <?php echo e(request()->routeIs('sub-categories.index') ? 'active' : ''); ?>">
                                  <i class="fas fa-list-alt nav-icon"></i>
                                  <p>Sub Categories</p>
                              </a>
                          </li>
                      </ul>
                  </li>


                  <li class="nav-item mt-auto">
                      <form method="POST" action="<?php echo e(url('/logout')); ?>">
                          <?php echo csrf_field(); ?>
                          <button type="submit"
                              class="nav-link btn btn-link text-left w-100 d-flex align-items-center"
                              style="color: #c2c7d0;">
                              <i class="nav-icon fas fa-sign-out-alt" style="color: red;"></i>
                              <p class="mb-0 ml-2">Logout</p>
                          </button>
                      </form>
                  </li>

              </ul>
          </nav>
      </div>
  </aside>
<?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/components/admin/admin_header.blade.php ENDPATH**/ ?>