<?php $__env->startSection('content'); ?>
<?php $__env->startSection('title', 'CEYLON THARU TOURS | ABOUT US'); ?>


<style>
    .section-about-title {
        display: inline-block;
        font-size: 1.1rem;
        font-weight: 600;
        color: #13357B;
        background: rgba(19, 53, 123, 0.1);
        padding: 8px 20px;
        border-radius: 30px;
        margin-bottom: 15px;
    }

    .service-item {
        transition: transform 0.3s;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        /* keeps spacing balanced */
    }

    .service-item:hover {
        transform: translateY(-10px);
    }

    .icon-box {
        transition: transform 0.3s;
    }

    .card:hover .icon-box {
        transform: rotateY(180deg);
    }

    blockquote {
        border-left: 4px solid #13357B;
        padding-left: 20px;
    }

    .fixed-img {
        height: 300px;
        /* set your desired equal height */
        width: 100%;
        object-fit: cover;
        /* crop images without distortion */
        display: block;
    }
</style>


<div class="container-fluid bg-breadcrumb"
    style="background: url(<?php echo e(asset('img/about_bg.jpg')); ?>) no-repeat center center;
            background-size: cover;
            background-attachment: fixed;">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">About Us</h3>
        <ol class="breadcrumb justify-content-center mb-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Pages</a></li>
            <li class="breadcrumb-item active text-white">About</li>
        </ol>
    </div>
</div>

<!-- About Start -->
<div class="container-fluid about py-5">
    <div class="container py-5">
        <div class="row g-5 align-items-center">
            <div class="col-lg-5">
                <div class="h-100" style="border: 50px solid; border-color: transparent #13357B transparent #13357B;">
                    <img src="<?php echo e(asset('img/about-img.jpg')); ?>" class="img-fluid w-100 h-100"
                        alt="Ceylon Tharu Tours Team">
                </div>
            </div>
            <div class="col-lg-7"
                style="background: linear-gradient(rgba(255, 255, 255, .8), rgba(255, 255, 255, .8)), url(<?php echo e(asset('img/about-img-1.png')); ?>);">
                <h5 class="section-about-title pe-3">About Us</h5>
                <h1 class="mb-4">Welcome to <span class="text-primary">Ceylon Tharu Tours</span></h1>
                <p class="mb-4">Ceylon Tharu Tours is your trusted partner for unforgettable travel experiences in Sri
                    Lanka. Our team of expert travel consultants and guides are passionate about showcasing the best of
                    Sri Lanka's culture, history, and natural beauty.</p>
                <p class="mb-4">We understand that every traveler is unique, and we strive to tailor our services to
                    meet the individual needs and preferences of our clients. From cultural tours to adventure
                    experiences, we offer a wide range of itineraries that cater to different interests and budgets.</p>
                <div class="row gy-2 gx-4 mb-4">
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>Customized Tours</p>
                    </div>
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>Expert Local Guides</p>
                    </div>
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>Quality Accommodations</p>
                    </div>
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>Modern Transportation</p>
                    </div>
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>Authentic Experiences</p>
                    </div>
                    <div class="col-sm-6">
                        <p class="mb-0"><i class="fa fa-arrow-right text-primary me-2"></i>24/7 Customer Support</p>
                    </div>
                </div>
                <a class="btn btn-primary rounded-pill py-3 px-5 mt-2" href="<?php echo e(route('packages')); ?>">Explore Our Packages</a>
            </div>
        </div>
    </div>
</div>
<!-- About End -->

<!-- Vision & Mission Start -->
<div class="container-fluid py-5" style="background-color: #f8f9fa;">
    <div class="container py-5">
        <div class="row g-5">
            <div class="col-lg-4">
                <div class="card border-0 shadow h-100">
                    <div class="card-body text-center p-4 p-sm-5">
                        <div class="icon-box bg-primary text-white rounded-circle mx-auto mb-4"
                            style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-eye fa-2x"></i>
                        </div>
                        <h4 class="mb-3">Our Vision</h4>
                        <p class="mb-0">To be the leading travel company in Sri Lanka, providing exceptional and
                            personalized travel experiences that showcase the island's rich culture, history, and
                            natural beauty.</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-0 shadow h-100">
                    <div class="card-body text-center p-4 p-sm-5">
                        <div class="icon-box bg-primary text-white rounded-circle mx-auto mb-4"
                            style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-bullseye fa-2x"></i>
                        </div>
                        <h4 class="mb-3">Our Mission</h4>
                        <p class="mb-0">To provide unique and unforgettable travel experiences that highlight the best
                            of Sri Lanka. We strive to deliver exceptional customer service, ensure safety and
                            satisfaction, and promote sustainable tourism practices.</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-0 shadow h-100">
                    <div class="card-body text-center p-4 p-sm-5">
                        <div class="icon-box bg-primary text-white rounded-circle mx-auto mb-4"
                            style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-leaf fa-2x"></i>
                        </div>
                        <h4 class="mb-3">Our Promise</h4>
                        <p class="mb-0">We prioritize authentic interactions with local communities and promote
                            responsible tourism practices to ensure a positive impact on the environment and local
                            communities.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Vision & Mission End -->

<!-- CEO Message Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="row g-5 align-items-center">
            <div class="col-lg-4 text-center">
                <div class="position-relative">
                    <img src="<?php echo e(asset('img/logo.png')); ?>" class="img-fluid rounded shadow"
                        alt="CEO of Ceylon Tharu Tours">
                </div>
            </div>
            <div class="col-lg-8">
                <div class="ps-lg-5">
                    <h5 class="section-about-title pe-3">Message from Our CEO</h5>
                    <h2 class="mb-4">Welcome to Ceylon Tharu Tours</h2>
                    <blockquote class="blockquote mb-4">
                        <p class="mb-0 fst-italic">"Welcome to Ceylon Tharu Tours, your premier travel partner in Sri
                            Lanka. As the CEO, I am proud to lead a team of dedicated professionals who share a passion
                            for showcasing the beauty and charm of our island nation.</p>
                        <p class="mb-4 fst-italic">Our team is committed to providing exceptional customer service,
                            ensuring that every traveler has a memorable and enjoyable experience in Sri Lanka. We
                            believe in promoting sustainable tourism practices and work closely with local communities
                            to support their development.</p>
                        <p class="mb-0 fst-italic">I invite you to explore Sri Lanka with us and experience the warmth
                            and hospitality of our people. Let us take you on a journey of discovery and adventure, and
                            create memories that will last a lifetime."</p>
                    </blockquote>
                    <div class="d-flex align-items-center">
                        <div>
                            <h5 class="mb-0">CEO, Ceylon Tharu Tours</h5>
                            <small class="text-muted">Kurunegala, Sri Lanka</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- CEO Message End -->

<!-- Services Start -->
<div class="container-fluid py-5" id="services" style="background-color: #f8f9fa;">
    <div class="container py-5">
        <div class="text-center mx-auto mb-5" style="max-width: 700px;">
            <h5 class="section-about-title px-3">Our Services</h5>
            <h1 class="mb-4">What We Offer</h1>
            <p class="mb-0">We provide comprehensive travel solutions to make your Sri Lankan adventure unforgettable
            </p>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-route fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">Customized Tours</h4>
                    <p class="mb-4">Tailor-made itineraries to suit your interests, budget, and preferences.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-user-tie fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">Expert Guides</h4>
                    <p class="mb-4">Knowledgeable local guides to provide insightful commentary and ensure a
                        memorable experience.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-hotel fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">Quality Accommodations</h4>
                    <p class="mb-4">Partnered with top-rated hotels, guesthouses, and resorts to provide comfortable
                        stays.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-car fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">Transportation</h4>
                    <p class="mb-4">Private vehicles and drivers for safe and convenient travel throughout Sri Lanka.
                    </p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-hiking fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">Adventure Activities</h4>
                    <p class="mb-4">Arranging activities such as wildlife safaris, water sports, and cultural
                        experiences.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white text-center rounded shadow p-4 p-xl-5 h-100">
                    <i class="fas fa-headset fa-3x text-primary mb-4"></i>
                    <h4 class="mb-3">24/7 Support</h4>
                    <p class="mb-4">Our dedicated customer support team is available to assist you throughout your
                        journey.</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Services End -->

<!-- Why Choose Us Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="row g-5">
            <div class="col-lg-6">
                <div class="mb-5">
                    <h5 class="section-about-title pe-3">Why Choose Us</h5>
                    <h1 class="mb-4">Your Gateway to Sri Lanka's Hidden Gems</h1>
                    <p class="mb-4">Ceylon Tharu Tours is dedicated to providing authentic and immersive travel
                        experiences that showcase the unseen beauty of Sri Lanka.</p>
                </div>
                <div class="row g-4">
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Authentic Experiences</h5>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Personalized Service</h5>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Sustainable Tourism</h5>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Local Expertise</h5>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Flexible Itineraries</h5>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle text-primary me-3 fa-2x"></i>
                            <h5 class="mb-0">Passionate Service</h5>
                        </div>
                    </div>
                </div>
                <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary rounded-pill py-3 px-5 mt-4">Contact Us
                    Today</a>
            </div>

            <div class="col-lg-6">
                <div class="row g-4">
                    <div class="col-6">
                        <img src="<?php echo e(asset('img/about-1.jpeg')); ?>" class="img-fluid rounded shadow mb-4 fixed-img"
                            alt="Cultural Experience">
                        <img src="<?php echo e(asset('img/about-2.jpeg')); ?>" class="img-fluid rounded shadow fixed-img"
                            alt="Wildlife Safari">
                    </div>
                    <div class="col-6">
                        <img src="<?php echo e(asset('img/about-3.jpeg')); ?>" class="img-fluid rounded shadow mb-4 fixed-img"
                            alt="Adventure Tour">
                        <img src="<?php echo e(asset('img/about-4.jpeg')); ?>" class="img-fluid rounded shadow fixed-img"
                            alt="Beach Experience">
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- Why Choose Us End -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/front/about.blade.php ENDPATH**/ ?>